#version 330 core

uniform float mytime;
in vec2 UV;
in vec4 vEyeSpacePos;
in vec4 aPos;
out vec4 fragColor;




const float fStart=0.0;
const float fEnd=30.0;

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0);

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;
	fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return fResult;
}

const float yc=-2.85;



// zero => no angular bound
uniform int iside; // -1=>hangbound=minimum, +1=>hangbound=maximum
uniform float hangbound;
uniform float xme;
uniform float zme;





#define MAX_ITER 8
void main( void ) {


	vec2 sp = vec2( 2*UV.x-1, 2*UV.y-1 );
	vec2 p = sp*5.0 - vec2(10.0);
	vec2 i = p;
	float c = 1.0;
	
	float inten = .1;

	for (int n = 0; n < MAX_ITER; n++) 
	{
		float t = mytime * (1.0 - (3.0 / float(n+1)));
		i = p + vec2(cos(t - i.x) + sin(t + i.y), sin(t - i.y) + cos(t + i.x));
		c += 1.0/length(vec2(p.x / (sin(i.x+t)/inten),p.y / (cos(i.y+t)/inten)));
	}
	c /= float(MAX_ITER);
	c = 1.5-sqrt(c);
	fragColor = vec4(vec3(c*c*c*c), 999.0) + vec4(0.0, 0.3, 0.5, 1.0);
	//fragColor.a = 0.9;
	fragColor.a = 0.6; // 18dec15 ...show piranha


	float dist2 = pow(vEyeSpacePos.x,2) + pow(vEyeSpacePos.z,2);
	float fFogCoord = abs( sqrt(dist2)/vEyeSpacePos.w );

	fragColor = mix(fragColor, vFogColor, getFogFactor(fFogCoord));


	float hang = atan(aPos.x-xme, aPos.z-zme);
	if     ( (iside>0) && (sin(hang-hangbound)>=0.0) ) discard;
	else if( (iside<0) && (sin(hang-hangbound)<=0.0) ) discard;



}


//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

