
--
-- Copyright (C) 2017  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl; use gl;

separate ( utex )

function loadtexshaders return interfaces.c.unsigned is
	pid : interfaces.c.unsigned;



------------- begin vertex shader code --------------------------
--
-- note that "ascii.lf&" seems to be necessary on linux
--      but I'm not sure it will work on OSX
--
	vscode :  string :=
"#version 330 core "& ascii.lf&
"layout(location = 0) in vec2 vertexPosition_screenspace; "& ascii.lf&
"layout(location = 1) in vec2 vertexUV; "& ascii.lf&
"uniform ivec2 screenCen; "& ascii.lf&
"out vec2 UV; "& ascii.lf&
"void main(){ "& ascii.lf&
"vec2 vertexPosition_homogeneousspace = vertexPosition_screenspace - screenCen;"& ascii.lf&
"vertexPosition_homogeneousspace /= screenCen;"& ascii.lf&

--"gl_Position = vec4(vertexPosition_homogeneousspace,0,1); "& ascii.lf&  --original line

"gl_Position = vec4(vertexPosition_homogeneousspace,-1,1); "& ascii.lf&
-- 7jan15 note:  this change allowed looking at a taller DHD without obscuring the "*"
-- BUT watch for ?other? unwanted side effects !!

"UV = vertexUV; }"& character'Val(0)
;

	avs : system.address := vscode'address;
------------- end vertex shader code --------------------------


------------- begin fragment shader code --------------------------
	fscode :  string :=
"#version 330 core "& ascii.lf&
"in vec2 UV; "& ascii.lf&
"out vec4 color; "& ascii.lf&
"uniform sampler2D myTextureSampler; "& ascii.lf&
"void main(){ "& ascii.lf&
"  color = texture( myTextureSampler, UV); "& ascii.lf&
"  if( color.a < 0.1 ) discard; }"& character'val(0) --12sep16 addition
;

	afs : system.address := fscode'address;

------------- end fragment shader code --------------------------


	vshaderid, fshaderid	 : aliased gluint;

use glext;
use glext.binding;
use gl.binding;



begin -- loadtexshaders

	vshaderid := glcreateshader(gl_vertex_shader);
	fshaderid := glcreateshader(gl_fragment_shader);

	glshadersource(vshaderid, 1, avs'address, system'to_address(0));
	glcompileshader(vshaderid);

	glshadersource(fshaderid, 1, afs'address, system'to_address(0) );
	glcompileshader(fshaderid);

	pid := glcreateprogram;
	glattachshader(pid, vshaderid);
	glattachshader(pid, fshaderid);
	gllinkprogram(pid);

	gldeleteshader(vshaderid);
	gldeleteshader(fshaderid);


	return pid;

end loadtexshaders;

