
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)


procedure setup_maze5 is 
--   scene #   5  (entry + above)

	yr,yc, xr,xc, zr,zc: float;
	hwdoor : constant float := 0.8; --halfWidth
	fhdoor : constant float := 1.8; --fullHeight

begin



-- initialize Black Key

	xbkey:= -5.0;
	zbkey:= -9.0;


	ybkey:=-iymax+htobj;
	sbkey:=5;

	pictobj.setrect( 
		key2, 
		xbkey,ybkey,zbkey, --xc,yc,zc
		rkey, 0.0, 0.5*rkey, --xr,yr,zr
		j1,j2,j3,j4,j5,j6);



	--walls
	droomobj.setrect( mdo5, -- no door needed here
		0.0, 0.0, 0.0,
		ixmax,iymax,izmax-0.01,
		ixmax/2.0,iymax,izmax/2.0); --scaled for 16 mirrored copies each wall



	--floor (grass covered)
	rectobj.setrect( 
		mfloor, 
		0.0, -iymax+0.01, 0.0, --xc,yc,zc
		ixmax, 0.0, izmax, --xr,yr,zr
		j1,j2,j3,j4,j5,j6);



-- begin maze walls => x,z within [-10,+10]

	yr:=0.3; -- 0.3 *2  is high enough
	yc:=-iymax+yr;
	xr:=0.5;
	zr:=0.5;
---------------------------------begin maze def

	for row in -mrows..mrows loop
	for col in -mcols..mcols loop
		if iswall(5,row,col) then

			-- definining coords were inverted so...
			-- negate both coords to match picture with
			-- leftward = +X, and upward = +Z
			xc:=float(row);
			zc:=float(col);

			if passthru(5,row,col) then
				rectobj.setrect( mzwall(5,row,col), 
					xc,yc,zc,  xr,yr,zr,
						j1,j2,j3,j4,j5,j6);
			else
				nko:=nko+1;
				koscene(nko):=5;
				rectobj.setrect( mzwall(5,row,col), 
					xc,yc,zc,  xr,yr,zr,
						koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
			end if;

		end if;
	end loop; --col
	end loop; --row

---------------------------------end maze def


-- setup ceiling for fancy fragshader:
rectxobj.setrect(rox,0.0,iymax-0.01,0.0, ixmax,0.01,izmax);
-- no texture needed here;  fancy fragshader used instead
	
--------------------------------------------------------


	--this maze entrance is at "bottom" @Zmin
	ixmaze:= 0.0;
	iymaze:=-iymax+fhdoor/2.0;
	izmaze:=-izmax;

	pictobj.setrect( 
		imazedoor,
		ixmaze, iymaze, izmaze+0.02,
		hwdoor, fhdoor/2.0, 0.0,
		j1,j2,j3,j4,j5,j6);
---------------------------------------------------


	--C
	pictobj.setrect( 
		doorc,
		10.0-eps, iymaze, 9.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

	--D
	pictobj.setrect( 
		doord,
		10.0-eps, iymaze, 4.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

	--E
	pictobj.setrect( 
		doore,
		10.0-eps, iymaze, 2.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

	--F
	pictobj.setrect( 
		doorf,
		10.0-eps, iymaze, 0.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

	--G
	pictobj.setrect( 
		doorg,
		10.0-eps, iymaze,-2.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

---------------------------------------------


	--Y
	pictobj.setrect( 
		doory,
		-10.0+eps, iymaze, 9.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

	--Z
	pictobj.setrect( 
		doorz,
		-10.0+eps, iymaze, 4.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

	--V
	pictobj.setrect( 
		doorv,
		-10.0+eps, iymaze, 2.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

	--W
	pictobj.setrect( 
		doorw,
		-10.0+eps, iymaze, 0.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);

	--X
	pictobj.setrect( 
		doorx,
		-10.0+eps, iymaze,-2.0,
		0.0, fhdoor/2.0, hwdoor,
		j1,j2,j3,j4,j5,j6);


end setup_maze5;



