#version 330 core

// vertex shader

layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;

out vec2 UV;
out vec4 vEyeSpacePos;
out vec4 aPos; // crazy experiment

// MVP must match string in glGetUniformLocation(pid,"MVP")
uniform mat4 MVP;
uniform mat4 MV;


uniform vec3 wPos;
uniform vec3 wRad;

uniform float horiAng; //new



void main(){

	vec3 opos = vertexPosition_modelspace;
	vec3 pos = vertexPosition_modelspace;

	opos.x *= wRad.x;
	opos.y *= wRad.y;
	opos.z *= wRad.z;
	// we assume original setup with unitary radii

	pos.y = opos.y;
	pos.x = +cos(horiAng)*opos.x + sin(horiAng)*opos.z;
	pos.z = -sin(horiAng)*opos.x + cos(horiAng)*opos.z;

	pos.x += wPos.x;
	pos.y += wPos.y;
	pos.z += wPos.z; 
	// we assume original setup @ origin

	aPos = vec4(pos,1.0);
	gl_Position =  MVP * aPos;
	vEyeSpacePos = MV * aPos;
	UV = vertexUV; 
}


//--
//-- Copyright (C) 2016  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

