/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import java.util.Stack;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DOMWrapper
extends Parser {
    private final boolean stripNS;
    private final String filename;
    private final Node root;
    private int nodes;

    public DOMWrapper(Document doc, String fn, MainOptions opts) {
        super(fn, opts);
        this.root = doc;
        this.filename = fn;
        this.stripNS = opts.get(MainOptions.STRIPNS);
    }

    @Override
    public void parse(Builder builder) throws IOException {
        builder.openDoc(Token.token(this.filename));
        Stack<NodeIterator> stack = new Stack<NodeIterator>();
        stack.push(new NodeIterator(this.root));
        while (!stack.empty()) {
            NodeIterator ni = (NodeIterator)stack.peek();
            if (ni.more()) {
                Node n = ni.curr();
                if (n instanceof Element) {
                    stack.push(new NodeIterator(n));
                    this.atts.reset();
                    this.nsp.reset();
                    NamedNodeMap at = n.getAttributes();
                    int as = at.getLength();
                    int a = 0;
                    while (a < as) {
                        Attr att = (Attr)at.item(a);
                        byte[] an = Token.token(att.getName());
                        byte[] av = Token.token(att.getValue());
                        if (Token.eq(an, Token.XMLNS)) {
                            if (!this.stripNS) {
                                this.nsp.add(Token.EMPTY, av);
                            }
                        } else if (Token.startsWith(an, Token.XMLNSC)) {
                            if (!this.stripNS) {
                                this.nsp.add(Token.local(an), av);
                            }
                        } else {
                            this.atts.add(this.stripNS ? Token.local(an) : an, av);
                        }
                        ++a;
                    }
                    byte[] en = Token.token(n.getNodeName());
                    builder.openElem(this.stripNS ? Token.local(en) : en, this.atts, this.nsp);
                } else if (n instanceof Text) {
                    builder.text(Token.token(n.getNodeValue()));
                } else if (n instanceof Comment) {
                    builder.comment(Token.token(n.getNodeValue()));
                } else if (n instanceof ProcessingInstruction) {
                    builder.pi(Token.token(String.valueOf(n.getNodeName()) + ' ' + n.getNodeValue()));
                }
                ++this.nodes;
                continue;
            }
            stack.pop();
            if (stack.empty()) break;
            builder.closeElem();
        }
        builder.closeDoc();
    }

    @Override
    public String detailedInfo() {
        return Util.info(org.basex.core.Text.NODES_PARSED_X_X, this.filename, this.nodes);
    }

    @Override
    public double progressInfo() {
        return (double)this.nodes / 1000000.0 % 1.0;
    }

    private static final class NodeIterator {
        private final NodeList nl;
        private int i = -1;

        NodeIterator(Node node) {
            this.nl = node.getChildNodes();
        }

        boolean more() {
            return ++this.i < this.nl.getLength();
        }

        Node curr() {
            return this.nl.item(this.i);
        }
    }
}

