/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.DropDB;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class Add
extends ACreate {
    private Builder build;
    DataClip clip;

    public Add(String path) {
        this(path, (String)null);
    }

    public Add(String path, String input) {
        super(Perm.WRITE, true, path == null ? "" : path, input);
    }

    @Override
    protected boolean run() {
        if (!this.build()) {
            return false;
        }
        try {
            final Data data = this.context.data();
            boolean bl = this.update(data, new ACreate.Code(){

                @Override
                boolean run() {
                    if (Add.this.clip.data.meta.size > 1) {
                        Add.this.context.invalidate();
                        AtomicUpdateCache auc = new AtomicUpdateCache(data);
                        auc.addInsert(data.meta.size, -1, Add.this.clip);
                        auc.execute(false);
                    }
                    return Add.this.info(Text.RES_ADDED_X, new Object[]{Add.this.jc().performance});
                }
            });
            return bl;
        }
        finally {
            this.finish();
        }
    }

    boolean build() {
        IO source;
        String name = MetaData.normPath(this.args[0]);
        if (name == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        try {
            source = this.sourceToIO(name);
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
        if (source == null) {
            return this.error(Text.RES_NOT_FOUND, new Object[0]);
        }
        if (!source.exists()) {
            return this.in != null ? this.error(Text.RES_NOT_FOUND, new Object[0]) : this.error(Text.RES_NOT_FOUND_X, this.context.user().has(Perm.CREATE) ? source : this.args[1]);
        }
        if (!name.endsWith("/") && (source.isDir() || source.isArchive())) {
            name = String.valueOf(name) + '/';
        }
        String target = "";
        int s = name.lastIndexOf(47);
        if (s != -1) {
            target = name.substring(0, s);
            name = name.substring(s + 1);
        }
        if (name.isEmpty()) {
            name = source.name();
        } else {
            source.name(name);
        }
        if (name.isEmpty()) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        try {
            Data data = this.context.data();
            DirParser parser = new DirParser(source, this.options, data.meta.path);
            parser.target(target);
            this.build = this.cache(parser) ? new DiskBuilder(this.soptions.randomDbName(data.meta.name), parser, this.soptions, this.options) : new MemBuilder(name, parser);
            this.clip = this.build.dataClip();
            return true;
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    void finish() {
        if (this.clip != null) {
            DropDB.drop(this.clip.data, this.soptions);
        }
    }

    private boolean cache(Parser parser) {
        Runtime rt;
        long max;
        IOFile f;
        if (this.options.get(MainOptions.MAINMEM).booleanValue()) {
            return false;
        }
        if (this.options.get(MainOptions.ADDCACHE).booleanValue()) {
            return true;
        }
        long fl = parser.source.length();
        if (parser.source instanceof IOFile && (f = (IOFile)parser.source).isDir()) {
            for (String d : f.descendants()) {
                fl += new IOFile(f, d).length();
            }
        }
        if (fl < ((max = (rt = Runtime.getRuntime()).maxMemory()) - rt.freeMemory()) / 2L) {
            return false;
        }
        Performance.gc(2);
        return fl > (max - rt.freeMemory()) / 2L;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg("TO", 0).arg(1);
    }

    @Override
    public String shortInfo() {
        return Text.ADD;
    }

    @Override
    public double progressInfo() {
        return this.build != null ? this.build.progressInfo() : 0.0;
    }
}

