/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Constr {
    public final ANodeList children = new ANodeList();
    public final ANodeList atts = new ANodeList();
    final Atts nspaces = new Atts();
    public QNm errAtt;
    public QNm duplAtt;
    QNm errNS;
    byte[] duplNS;
    private final StaticContext sc;
    private final InputInfo info;
    private final TokenBuilder text = new TokenBuilder();
    private boolean more;

    public Constr(InputInfo info, StaticContext sc) {
        this.info = info;
        this.sc = sc;
    }

    public Constr add(QueryContext qc, Expr ... exprs) throws QueryException {
        int size = this.sc.ns.size();
        try {
            Expr[] exprArray = exprs;
            int n = exprs.length;
            int n2 = 0;
            while (n2 < n) {
                Item item;
                Expr expr = exprArray[n2];
                this.more = false;
                Iter iter = expr.iter(qc);
                while ((item = qc.next(iter)) != null && this.add(qc, item)) {
                }
                ++n2;
            }
            if (!this.text.isEmpty()) {
                this.children.add(new FTxt(this.text.toArray()));
            }
            Constr constr = this;
            return constr;
        }
        finally {
            this.sc.ns.size(size);
        }
    }

    private boolean add(QueryContext qc, Item item) throws QueryException {
        if (item instanceof Array) {
            for (Value value : ((Array)item).members()) {
                for (Item it : value) {
                    if (this.add(qc, it)) continue;
                    return false;
                }
            }
            return true;
        }
        if (item instanceof FItem) {
            throw QueryError.CONSFUNC_X.get(this.info, item);
        }
        if (item instanceof ANode) {
            ANode node = (ANode)item;
            Type type = item.type;
            if (type == NodeType.TXT) {
                this.text.add(node.string());
            } else if (type == NodeType.ATT) {
                QNm name = node.qname();
                if (!this.text.isEmpty() || !this.children.isEmpty()) {
                    this.errAtt = name;
                    return false;
                }
                for (ANode att : this.atts) {
                    if (!name.eq(att.qname())) continue;
                    this.duplAtt = name;
                    return false;
                }
                this.atts.add(new FAttr(name, node.string()));
                if (name.hasURI()) {
                    this.sc.ns.add(name.prefix(), name.uri());
                }
            } else if (type == NodeType.NSP) {
                if (!this.text.isEmpty() || !this.children.isEmpty()) {
                    this.errNS = node.qname();
                    return false;
                }
                byte[] name = node.name();
                byte[] uri = node.string();
                byte[] knownUri = this.nspaces.value(name);
                if (knownUri == null) {
                    this.nspaces.add(name, uri);
                } else if (!Token.eq(uri, knownUri)) {
                    this.duplNS = name;
                    return false;
                }
            } else if (type == NodeType.DOC) {
                Item it;
                BasicNodeIter iter = node.children();
                while ((it = qc.next(iter)) != null && this.add(qc, it)) {
                }
            } else {
                MainOptions mopts;
                if (!this.text.isEmpty()) {
                    this.children.add(new FTxt(this.text.next()));
                }
                if ((mopts = qc.context.options).get(MainOptions.COPYNODE).booleanValue()) {
                    node = node.deepCopy(mopts, qc);
                }
                this.children.add(node);
            }
            this.more = false;
        } else {
            if (this.more) {
                this.text.add(32);
            }
            this.text.add(item.string(this.info));
            this.more = true;
        }
        return true;
    }
}

