/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.math.BigInteger;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.bin.BinFn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class BinOctal
extends BinFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] bytes = this.str(0, qc);
        if (bytes == null) {
            return null;
        }
        int bl = bytes.length;
        if (bl == 0) {
            return B64.EMPTY;
        }
        try {
            byte[] bin = Token.token(new BigInteger(Token.string(bytes), 8).toString(2));
            int expl = bl * 3;
            int binl = bin.length;
            if (binl != expl) {
                byte[] tmp = new byte[expl];
                Arrays.fill(tmp, 0, expl - binl, (byte)48);
                System.arraycopy(bin, 0, tmp, expl - binl, binl);
                bin = tmp;
            }
            return B64.get(this.binary2bytes(bin));
        }
        catch (NumberFormatException ex) {
            Util.debug(ex);
            throw QueryError.BIN_NNC.get(this.info, new Object[0]);
        }
    }
}

