/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.FingerTreeBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.array.BigArray;
import org.basex.query.value.array.LeafNode;
import org.basex.query.value.array.SmallArray;
import org.basex.util.Util;

public final class ArrayBuilder {
    private static final int CAP = 38;
    private static final int NODE_SIZE = 12;
    private final Value[] vals = new Value[38];
    private int inLeft;
    private int mid = 19;
    private int inRight;
    private final FingerTreeBuilder<Value> tree = new FingerTreeBuilder();

    public ArrayBuilder prepend(Value elem) {
        if (this.inLeft < 19) {
            this.vals[(this.mid - this.inLeft + 38 - 1) % 38] = elem;
            ++this.inLeft;
        } else if (this.tree.isEmpty() && this.inRight < 19) {
            this.mid = (this.mid + 38 - 1) % 38;
            this.vals[(this.mid - this.inLeft + 38) % 38] = elem;
            ++this.inRight;
        } else {
            Value[] leaf = new Value[12];
            int start = (this.mid - 12 + 38) % 38;
            int i = 0;
            while (i < 12) {
                leaf[i] = this.vals[(start + i) % 38];
                ++i;
            }
            this.tree.prepend(new LeafNode(leaf));
            int rest = this.inLeft - 12;
            int p0 = (this.mid - this.inLeft + 38) % 38;
            int i2 = 0;
            while (i2 < rest) {
                int from = (p0 + i2) % 38;
                int to = (from + 12) % 38;
                this.vals[to] = this.vals[from];
                ++i2;
            }
            this.vals[(this.mid - rest + 38 - 1) % 38] = elem;
            this.inLeft = rest + 1;
        }
        return this;
    }

    public ArrayBuilder append(Value elem) {
        if (this.inRight < 19) {
            this.vals[(this.mid + this.inRight) % 38] = elem;
            ++this.inRight;
        } else if (this.tree.isEmpty() && this.inLeft < 19) {
            this.mid = (this.mid + 1) % 38;
            this.vals[(this.mid + this.inRight + 38 - 1) % 38] = elem;
            ++this.inLeft;
        } else {
            Value[] leaf = new Value[12];
            int start = this.mid;
            int i = 0;
            while (i < 12) {
                leaf[i] = this.vals[(start + i) % 38];
                ++i;
            }
            this.tree.append(new LeafNode(leaf));
            int rest = this.inRight - 12;
            int i2 = 0;
            while (i2 < rest) {
                int to = (this.mid + i2) % 38;
                int from = (to + 12) % 38;
                this.vals[to] = this.vals[from];
                ++i2;
            }
            this.vals[(this.mid + rest) % 38] = elem;
            this.inRight = rest + 1;
        }
        return this;
    }

    public ArrayBuilder append(Array arr) {
        if (!(arr instanceof BigArray)) {
            for (Value value : arr.members()) {
                this.append(value);
            }
            return this;
        }
        BigArray big = (BigArray)arr;
        Value[] ls = big.left;
        Value[] rs = big.right;
        FingerTree<Value, Value> midTree = big.middle;
        if (midTree.isEmpty()) {
            Value[] valueArray = big.left;
            int n = big.left.length;
            int n2 = 0;
            while (n2 < n) {
                Value l = valueArray[n2];
                this.append(l);
                ++n2;
            }
            valueArray = big.right;
            n = big.right.length;
            n2 = 0;
            while (n2 < n) {
                Value r = valueArray[n2];
                this.append(r);
                ++n2;
            }
            return this;
        }
        if (this.tree.isEmpty()) {
            int k = this.inLeft + this.inRight;
            Value[] temp = new Value[k];
            int l = (this.mid - this.inLeft + 38) % 38;
            int m = 38 - l;
            if (k <= m) {
                System.arraycopy(this.vals, l, temp, 0, k);
            } else {
                System.arraycopy(this.vals, l, temp, 0, m);
                System.arraycopy(this.vals, 0, temp, m, k - m);
            }
            this.inRight = 0;
            this.inLeft = 0;
            this.tree.append(midTree);
            int i = ls.length;
            while (--i >= 0) {
                this.prepend(ls[i]);
            }
            i = k;
            while (--i >= 0) {
                this.prepend(temp[i]);
            }
            Value[] valueArray = rs;
            int n = rs.length;
            int n3 = 0;
            while (n3 < n) {
                Value r = valueArray[n3];
                this.append(r);
                ++n3;
            }
            return this;
        }
        int inMiddle = this.inRight + big.left.length;
        int leaves = (inMiddle + 15 - 1) / 15;
        int leafSize = (inMiddle + leaves - 1) / leaves;
        int i = 0;
        int l = 0;
        while (l < leaves) {
            int inLeaf = Math.min(leafSize, inMiddle - i);
            Value[] leaf = new Value[inLeaf];
            int p = 0;
            while (p < inLeaf) {
                leaf[p] = i < this.inRight ? this.vals[(this.mid + i) % 38] : big.left[i - this.inRight];
                ++i;
                ++p;
            }
            this.tree.append(new LeafNode(leaf));
            ++l;
        }
        this.tree.append(big.middle);
        this.inRight = 0;
        Value[] valueArray = big.right;
        int n = big.right.length;
        int n4 = 0;
        while (n4 < n) {
            Value r = valueArray[n4];
            this.append(r);
            ++n4;
        }
        return this;
    }

    public Array freeze() {
        int n = this.inLeft + this.inRight;
        if (n == 0) {
            return Array.empty();
        }
        int start = (this.mid - this.inLeft + 38) % 38;
        if (n <= 7) {
            Value[] small = new Value[n];
            int i = 0;
            while (i < n) {
                small[i] = this.vals[(start + i) % 38];
                ++i;
            }
            return new SmallArray(small);
        }
        int a = this.tree.isEmpty() ? n / 2 : this.inLeft;
        int b = n - a;
        Value[] ls = new Value[a];
        Value[] rs = new Value[b];
        int i = 0;
        while (i < a) {
            ls[i] = this.vals[(start + i) % 38];
            ++i;
        }
        i = a;
        while (i < n) {
            rs[i - a] = this.vals[(start + i) % 38];
            ++i;
        }
        return new BigArray(ls, this.tree.freeze(), rs);
    }

    public String toString() {
        StringBuilder sb;
        block5: {
            block4: {
                sb = new StringBuilder(Util.className(this)).append('[');
                if (!this.tree.isEmpty()) break block4;
                int n = this.inLeft + this.inRight;
                int first = (this.mid - this.inLeft + 38) % 38;
                if (n <= 0) break block5;
                sb.append(this.vals[first]);
                int i = 1;
                while (i < n) {
                    sb.append(", ").append(this.vals[(first + i) % 38]);
                    ++i;
                }
                break block5;
            }
            int first = (this.mid - this.inLeft + 38) % 38;
            sb.append(this.vals[first]);
            int i = 1;
            while (i < this.inLeft) {
                sb.append(", ").append(this.vals[(first + i) % 38]);
                ++i;
            }
            for (Value value : this.tree) {
                sb.append(", ").append(value);
            }
            i = 0;
            while (i < this.inRight) {
                sb.append(", ").append(this.vals[(this.mid + i) % 38]);
                ++i;
            }
        }
        return sb.append(']').toString();
    }
}

