/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.var.StaticVar;
import org.basex.query.var.StaticVarRef;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class Variables
extends ExprInfo
implements Iterable<StaticVar> {
    private final HashMap<QNm, VarEntry> vars = new HashMap();

    public StaticVar declare(Var var, AnnList anns, Expr expr, boolean ext, String doc, VarScope vs) throws QueryException {
        StaticVar sv = new StaticVar(vs, anns, var, expr, ext, doc);
        VarEntry ve = this.vars.get(var.name);
        if (ve != null) {
            ve.setVar(sv);
        } else {
            this.vars.put(var.name, new VarEntry(sv));
        }
        return sv;
    }

    public void checkUp() throws QueryException {
        for (VarEntry e : this.vars.values()) {
            e.var.checkUp();
        }
    }

    public void check() throws QueryException {
        for (VarEntry ve : this.vars.values()) {
            if (ve.var != null) continue;
            StaticVarRef vr = ve.refs.get(0);
            throw QueryError.VARUNDEF_X.get(vr.info, vr);
        }
    }

    public StaticVarRef newRef(QNm name, StaticContext sc, InputInfo info) throws QueryException {
        VarEntry entry;
        StaticVarRef ref = new StaticVarRef(info, name, sc);
        VarEntry e = this.vars.get(name);
        VarEntry varEntry = entry = e != null ? e : new VarEntry(null);
        if (e == null) {
            this.vars.put(name, entry);
        }
        entry.addRef(ref);
        return ref;
    }

    public void bindExternal(QueryContext qc, HashMap<QNm, Value> bindings) throws QueryException {
        for (Map.Entry<QNm, Value> entry : bindings.entrySet()) {
            VarEntry ve = this.vars.get(entry.getKey());
            if (ve == null) continue;
            ve.var.bind(entry.getValue(), qc);
        }
    }

    @Override
    public Iterator<StaticVar> iterator() {
        final Iterator<Map.Entry<QNm, VarEntry>> iter = this.vars.entrySet().iterator();
        return new Iterator<StaticVar>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public StaticVar next() {
                return ((VarEntry)((Map.Entry)iter.next()).getValue()).var;
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    public void plan(FElem plan) {
        if (this.vars.isEmpty()) {
            return;
        }
        FElem elem = this.planElem(new Object[0]);
        for (VarEntry v : this.vars.values()) {
            v.var.plan(elem);
        }
        plan.add(elem);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (VarEntry v : this.vars.values()) {
            sb.append(v.var);
        }
        return sb.toString();
    }

    private static class VarEntry {
        StaticVar var;
        final ArrayList<StaticVarRef> refs = new ArrayList(1);

        VarEntry(StaticVar var) {
            this.var = var;
        }

        void setVar(StaticVar vr) throws QueryException {
            if (this.var != null) {
                throw QueryError.VARDUPL_X.get(vr.info, new Object[]{this.var.name.string()});
            }
            this.var = vr;
            for (StaticVarRef ref : this.refs) {
                ref.init(this.var);
            }
        }

        void addRef(StaticVarRef ref) throws QueryException {
            this.refs.add(ref);
            if (this.var != null) {
                ref.init(this.var);
            }
        }
    }
}

