/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import java.util.Objects;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class Array {
    public static final int MAXINIT = 0x100000;
    public static final int CAPACITY = 8;
    public static final double RESIZE = 1.5;

    private Array() {
    }

    public static byte[][] copyOf(byte[][] array, int size) {
        byte[][] tmp = new byte[size][];
        System.arraycopy(array, 0, tmp, 0, Math.min(size, array.length));
        return tmp;
    }

    public static int[][] copyOf(int[][] array, int size) {
        int[][] tmp = new int[size][];
        System.arraycopy(array, 0, tmp, 0, Math.min(size, array.length));
        return tmp;
    }

    public static String[] copyOf(String[] array, int size) {
        String[] tmp = new String[size];
        System.arraycopy(array, 0, tmp, 0, Math.min(size, array.length));
        return tmp;
    }

    public static <T> T[] add(T[] array, T entry) {
        int s = array.length;
        T[] t = Arrays.copyOf(array, s + 1);
        t[s] = entry;
        return t;
    }

    public static int[] add(int[] array, int entry) {
        int s = array.length;
        int[] t = Arrays.copyOf(array, s + 1);
        t[s] = entry;
        return t;
    }

    public static void move(Object array, int pos, int off, int size) {
        System.arraycopy(array, pos, array, pos + off, size);
    }

    public static <T> T[] copy(T[] source, T[] target) {
        System.arraycopy(source, 0, target, 0, Math.min(source.length, target.length));
        return target;
    }

    public static <T> T[] delete(T[] array, int pos) {
        int s = array.length - 1;
        T[] tmp = Arrays.copyOf(array, s);
        System.arraycopy(array, pos + 1, tmp, pos, s - pos);
        return tmp;
    }

    public static int[] createOrder(byte[][] values, boolean numeric, boolean ascending) {
        IntList il = Array.number(values.length);
        il.sort(values, numeric, ascending);
        return il.finish();
    }

    public static int[] createOrder(double[] values, boolean ascending) {
        IntList il = Array.number(values.length);
        il.sort(values, ascending);
        return il.finish();
    }

    public static int[] createOrder(int[] values, boolean ascending) {
        IntList il = Array.number(values.length);
        il.sort(values, ascending);
        return il.finish();
    }

    public static int[] createOrder(long[] values, boolean ascending) {
        IntList il = Array.number(values.length);
        il.sort(values, ascending);
        return il.finish();
    }

    public static IntList number(int size) {
        int[] tmp = new int[size];
        int i = 0;
        while (i < size) {
            tmp[i] = i;
            ++i;
        }
        return new IntList(tmp);
    }

    public static void reverse(byte[] array) {
        Array.reverse(array, 0, array.length);
    }

    private static void reverse(byte[] array, int pos, int len) {
        int l = pos;
        int r = pos + len - 1;
        while (l < r) {
            byte tmp = array[l];
            array[l] = array[r];
            array[r] = tmp;
            ++l;
            --r;
        }
    }

    public static void reverse(Object[] array, int pos, int len) {
        int l = pos;
        int r = pos + len - 1;
        while (l < r) {
            Object tmp = array[l];
            array[l] = array[r];
            array[r] = tmp;
            ++l;
            --r;
        }
    }

    public static int newSize(int old) {
        return Array.newSize(old, 1.5);
    }

    public static int newSize(int old, double factor) {
        int s = Math.min(0x7FFFFFFA, (int)((double)old * factor) + 1);
        if (s <= old) {
            throw new ArrayIndexOutOfBoundsException("Maximum array size reached.");
        }
        return s;
    }

    public static boolean equals(byte[][] tokens1, byte[][] tokens2) {
        if (tokens1 == tokens2) {
            return true;
        }
        if (tokens1 == null || tokens2 == null) {
            return false;
        }
        int al = tokens1.length;
        if (al != tokens2.length) {
            return false;
        }
        int a = 0;
        while (a < al) {
            if (!Token.eq(tokens1[a], tokens2[a])) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public static boolean equals(Object[] arr1, Object[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        int al = arr1.length;
        if (al != arr2.length) {
            return false;
        }
        int a = 0;
        while (a < al) {
            if (!Objects.equals(arr1[a], arr2[a])) {
                return false;
            }
            ++a;
        }
        return true;
    }
}

