/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.basex.core.MainOptions;
import org.basex.query.QueryException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.http.HttpPayload;
import org.basex.util.http.HttpText;
import org.basex.util.http.MediaType;

public final class HttpResponse {
    private final InputInfo info;
    private final MainOptions options;

    public HttpResponse(InputInfo info, MainOptions options) {
        this.info = info;
        this.options = options;
    }

    public Value getResponse(HttpURLConnection conn, boolean body, String mtype) throws IOException, QueryException {
        InputStream is;
        boolean error = false;
        try {
            is = conn.getInputStream();
        }
        catch (IOException ex) {
            Util.debug(ex);
            is = conn.getErrorStream();
            error = true;
        }
        ItemList items = new ItemList();
        FElem response = new FElem(HttpText.Q_RESPONSE).declareNS();
        items.add(response);
        String msg = conn.getResponseMessage();
        response.add(HttpText.STATUS, Token.token(conn.getResponseCode()));
        response.add(HttpText.MESSAGE, msg == null ? "" : msg);
        for (String header : conn.getHeaderFields().keySet()) {
            if (header == null) continue;
            FElem hdr = new FElem(HttpText.Q_HEADER);
            hdr.add("name", header);
            hdr.add("value", conn.getHeaderField(header));
            response.add(hdr);
        }
        if (is != null) {
            try {
                HttpPayload hp = new HttpPayload(is, body, this.info, this.options);
                String ctype = conn.getContentType();
                MediaType type = error || mtype == null ? (ctype == null ? MediaType.TEXT_PLAIN : new MediaType(ctype)) : new MediaType(mtype);
                response.add(hp.parse(type, error, conn.getHeaderField("Content-Encoding")));
                if (body) {
                    items.add(hp.payloads());
                }
            }
            finally {
                is.close();
            }
        }
        return items.value();
    }
}

