/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.io.IOFile;
import org.basex.util.Table;
import org.basex.util.list.TokenList;

public final class ShowBackups
extends ABackup {
    public ShowBackups() {
        super(new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        Table table = new Table();
        table.description = Text.BACKUPS_X;
        table.header.add(Text.NAME);
        table.header.add(Text.SIZE);
        IOFile dbpath = this.soptions.dbPath();
        for (String name : this.context.databases.backups()) {
            TokenList tl = new TokenList();
            tl.add(name);
            tl.add(new IOFile(dbpath, String.valueOf(name) + ".zip").length());
            table.contents.add(tl);
        }
        this.out.println(table.sort().finish());
        return true;
    }

    @Override
    public boolean updating(Context ctx) {
        return false;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.SHOW) + " " + (Object)((Object)Commands.CmdShow.BACKUPS));
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("%BACKUP");
    }
}

