/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.users;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Databases;
import org.basex.core.users.Algorithm;
import org.basex.core.users.Code;
import org.basex.core.users.Perm;
import org.basex.core.users.UserText;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.XMLAccess;

public final class User {
    private final EnumMap<Algorithm, EnumMap<Code, String>> passwords = new EnumMap(Algorithm.class);
    private final LinkedHashMap<String, Perm> locals = new LinkedHashMap();
    private String name;
    private Perm perm;

    public User(String name, String password) {
        this.name = name;
        this.perm = Perm.NONE;
        Algorithm[] algorithmArray = Algorithm.values();
        int n = algorithmArray.length;
        int n2 = 0;
        while (n2 < n) {
            Algorithm algo = algorithmArray[n2];
            this.passwords.put(algo, new EnumMap(Code.class));
            ++n2;
        }
        this.password(password);
    }

    User(ANode user) throws BaseXException {
        this.name = Token.string(XMLAccess.attribute("Root", user, UserText.NAME));
        this.perm = (Perm)XMLAccess.attribute((String)this.name, (ANode)user, (byte[])UserText.PERMISSION, (Enum[])Perm.values());
        for (ANode child : XMLAccess.children(user)) {
            if (Token.eq(child.qname().id(), UserText.PASSWORD)) {
                EnumMap<Code, String> ec = new EnumMap<Code, String>(Code.class);
                Algorithm algo = (Algorithm)XMLAccess.attribute((String)this.name, (ANode)child, (byte[])UserText.ALGORITHM, (Enum[])Algorithm.values());
                if (this.passwords.containsKey((Object)algo)) {
                    throw new BaseXException(String.valueOf(this.name) + ": Algorithm \"" + (Object)((Object)algo) + "\" supplied more than once.", new Object[0]);
                }
                this.passwords.put(algo, ec);
                for (Object code : XMLAccess.children(child)) {
                    Code cd = (Code)XMLAccess.value((String)this.name, (byte[])code.qname().id(), (Enum[])algo.codes);
                    if (ec.containsKey((Object)cd)) {
                        throw new BaseXException(String.valueOf(this.name) + ", " + (Object)((Object)algo) + ": Code \"" + code + "\" supplied more than once.", new Object[0]);
                    }
                    ec.put(cd, Token.string(code.string()));
                }
                Code[] codeArray = algo.codes;
                int n = algo.codes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object code;
                    code = codeArray[n2];
                    if (ec.get(code) == null) {
                        throw new BaseXException(String.valueOf(this.name) + ", " + (Object)((Object)algo) + ": Code \"" + code + "\" missing.", new Object[0]);
                    }
                    ++n2;
                }
                continue;
            }
            if (Token.eq(child.qname().id(), UserText.DATABASE)) {
                String nm = Token.string(XMLAccess.attribute(this.name, child, UserText.PATTERN));
                Perm prm = (Perm)XMLAccess.attribute((String)this.name, (ANode)child, (byte[])UserText.PERMISSION, (Enum[])Perm.values());
                this.locals.put(nm, prm);
                continue;
            }
            throw new BaseXException(String.valueOf(this.name) + ": invalid element: <" + child.qname() + "/>.", new Object[0]);
        }
        Algorithm[] algorithmArray = Algorithm.values();
        int n = algorithmArray.length;
        int n3 = 0;
        while (n3 < n) {
            Algorithm algo = algorithmArray[n3];
            if (this.passwords.get((Object)algo) == null) {
                throw new BaseXException(String.valueOf(this.name) + ": Algorithm \"" + (Object)((Object)algo) + "\" missing.", new Object[0]);
            }
            ++n3;
        }
    }

    synchronized void toXML(FElem root) {
        FElem user = new FElem(UserText.USER).add(UserText.NAME, this.name).add(UserText.PERMISSION, this.perm.toString());
        this.passwords.forEach((key, value) -> {
            FElem pw = new FElem(UserText.PASSWORD).add(UserText.ALGORITHM, key.toString());
            value.forEach((k, v) -> {
                if (!v.isEmpty()) {
                    pw.add(new FElem(k.toString()).add((String)v));
                }
            });
            user.add(pw);
        });
        this.locals.forEach((key, value) -> {
            FElem fElem2 = user.add(new FElem(UserText.DATABASE).add(UserText.PATTERN, (String)key).add(UserText.PERMISSION, value.toString()));
        });
        root.add(user);
    }

    synchronized void name(String nm) {
        this.name = nm;
    }

    public synchronized void drop(String pattern) {
        this.locals.remove(pattern);
    }

    public synchronized Map<String, Perm> locals() {
        return this.locals;
    }

    public synchronized String name() {
        return this.name;
    }

    public synchronized void password(String password) {
        EnumMap<Code, String> codes = this.passwords.get((Object)Algorithm.DIGEST);
        codes.put(Code.HASH, User.digest(this.name, password));
        codes = this.passwords.get((Object)Algorithm.SALTED_SHA256);
        String salt = Long.toString(System.nanoTime());
        codes.put(Code.SALT, salt);
        codes.put(Code.HASH, Strings.sha256(String.valueOf(salt) + password));
    }

    public synchronized String code(Algorithm alg, Code code) {
        return this.passwords.get((Object)alg).get((Object)code);
    }

    public synchronized EnumMap<Algorithm, EnumMap<Code, String>> alg() {
        return this.passwords;
    }

    public synchronized Perm perm(String db) {
        Map.Entry<String, Perm> entry;
        if (db != null && (entry = this.find(db)) != null) {
            return entry.getValue();
        }
        return this.perm;
    }

    synchronized Map.Entry<String, Perm> find(String db) {
        for (Map.Entry<String, Perm> entry : this.locals.entrySet()) {
            if (!Databases.regex(entry.getKey()).matcher(db).matches()) continue;
            return entry;
        }
        return null;
    }

    public synchronized User perm(Perm prm) {
        this.perm = prm;
        return this;
    }

    public synchronized User perm(Perm prm, String pattern) {
        if (pattern.isEmpty()) {
            this.perm(prm);
        } else {
            this.locals.put(pattern, prm);
        }
        return this;
    }

    public synchronized boolean has(Perm prm) {
        return this.has(prm, null);
    }

    public synchronized boolean has(Perm prm, String db) {
        return this.perm(db).ordinal() >= prm.ordinal();
    }

    public synchronized boolean matches(String password) {
        EnumMap<Code, String> alg = this.passwords.get((Object)Algorithm.SALTED_SHA256);
        return Strings.sha256(String.valueOf(alg.get((Object)Code.SALT)) + password).equals(alg.get((Object)Code.HASH));
    }

    static String digest(String name, String password) {
        return Strings.md5(String.valueOf(name) + ':' + "BaseX" + ':' + password);
    }
}

