/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;

public final class DialogBindings
extends BaseXDialog {
    private static final int MAX = 8;
    private final BaseXTextField[] names = new BaseXTextField[8];
    private final BaseXTextField[] values = new BaseXTextField[8];
    private final BaseXTextField ctxitem;

    public DialogBindings(GUI gui) {
        super(gui, Text.EXTERNAL_VARIABLES);
        ((BorderLayout)this.panel.getLayout()).setHgap(4);
        BaseXBack west = new BaseXBack(new GridLayout(10, 1, 0, 4));
        west.add(new BaseXLabel(String.valueOf(Text.NAME) + ": ", false, true));
        int c = 0;
        while (c < 8) {
            this.names[c] = new BaseXTextField(this);
            BaseXLayout.setWidth(this.names[c], 100);
            west.add(this.names[c]);
            ++c;
        }
        west.add(new BaseXLabel("Context item: "));
        this.set(west, "West");
        BaseXBack center = new BaseXBack(new GridLayout(10, 1, 0, 4));
        center.add(new BaseXLabel(String.valueOf(Text.VALUE) + ": ", false, true));
        int c2 = 0;
        while (c2 < 8) {
            this.values[c2] = new BaseXTextField(this);
            BaseXLayout.setWidth(this.values[c2], 250);
            center.add(this.values[c2]);
            ++c2;
        }
        this.ctxitem = new BaseXTextField(this);
        center.add(this.ctxitem);
        this.set(center, "Center");
        this.set(this.okCancel(), "South");
        this.fill();
        this.ok = true;
        this.setResizable(true);
        this.finish();
    }

    private void fill() {
        MainOptions opts = this.gui.context.options;
        int c = 0;
        for (Map.Entry<String, String> entry : opts.toMap(MainOptions.BINDINGS).entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name.isEmpty()) {
                this.ctxitem.setText(value);
                continue;
            }
            if (c >= 8) continue;
            this.names[c].setText(String.valueOf('$') + name.replaceAll("^\\$", ""));
            this.values[c].setText(value);
            ++c;
        }
        while (c < 8) {
            this.names[c].setText("$");
            this.values[c].setText("");
            ++c;
        }
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        super.close();
        StringBuilder bind = new StringBuilder();
        int c = 0;
        while (c < 8) {
            String name = this.names[c].getText().replaceAll("^\\s*\\$|\\s+$", "");
            if (!name.isEmpty()) {
                bind.append((String.valueOf(name) + '=' + this.values[c].getText()).replaceAll(",", ",,")).append(',');
            }
            ++c;
        }
        String value = this.ctxitem.getText();
        if (!value.isEmpty()) {
            bind.append('=').append(value.replaceAll(",", ",,")).append(',');
        }
        this.gui.set(MainOptions.BINDINGS, bind.toString().replaceAll(",$", ""));
    }
}

