/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.text.DecimalFormat;
import org.basex.core.Lang;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.util.Performance;

final class DialogGeneralPrefs
extends BaseXBack {
    private final GUI gui;
    private static final int[] MAXRESULTS = new int[]{50000, 100000, 250000, 500000, 1000000, 2500000, Integer.MAX_VALUE};
    private static final int[] MAXTEXT = new int[]{0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, Integer.MAX_VALUE};
    private static final String[][] LANGS = Lang.parse();
    private final BaseXTextField dbPath;
    private final BaseXTextField repoPath;
    private final BaseXSlider maxResults;
    private final BaseXSlider maxText;
    private final BaseXLabel labelResults;
    private final BaseXLabel labelText;
    private final BaseXLabel creds;
    private final BaseXCombo lang;
    private final BaseXCheckBox mousefocus;
    private final BaseXButton dbButton;
    private final BaseXButton repoButton;

    DialogGeneralPrefs(BaseXDialog dialog) {
        this.border(8).setLayout(new TableLayout(10, 1));
        this.gui = dialog.gui;
        StaticOptions opts = this.gui.context.soptions;
        GUIOptions gopts = this.gui.gopts;
        this.dbPath = new BaseXTextField(dialog, opts.get(StaticOptions.DBPATH));
        this.repoPath = new BaseXTextField(dialog, opts.get(StaticOptions.REPOPATH));
        this.dbButton = new BaseXButton(dialog, Text.BROWSE_D);
        this.dbButton.addActionListener(e -> {
            String path = this.dbPath.getText();
            IOFile dir = new BaseXFileChooser(dialog, Text.CHOOSE_DIR, path).select(BaseXFileChooser.Mode.DOPEN);
            if (dir != null) {
                this.dbPath.setText(dir.path());
            }
        });
        this.repoButton = new BaseXButton(dialog, Text.BROWSE_D);
        this.repoButton.addActionListener(e -> {
            String path = this.repoPath.getText();
            IOFile dir = new BaseXFileChooser(dialog, Text.CHOOSE_DIR, path).select(BaseXFileChooser.Mode.DOPEN);
            if (dir != null) {
                this.repoPath.setText(dir.path());
            }
        });
        this.mousefocus = new BaseXCheckBox(dialog, Text.RT_FOCUS, GUIOptions.MOUSEFOCUS, gopts);
        int val = DialogGeneralPrefs.sliderIndex(this.gui.gopts.get(GUIOptions.MAXRESULTS), MAXRESULTS);
        this.maxResults = new BaseXSlider(dialog, 0, MAXRESULTS.length - 1, val);
        this.maxResults.addActionListener(e -> {
            boolean bl = this.action(this.maxResults);
        });
        this.labelResults = new BaseXLabel(" ");
        val = DialogGeneralPrefs.sliderIndex(this.gui.gopts.get(GUIOptions.MAXTEXT), MAXTEXT);
        this.maxText = new BaseXSlider(dialog, 0, MAXTEXT.length - 1, val);
        this.maxText.addActionListener(e -> {
            boolean bl = this.action(this.maxText);
        });
        this.labelText = new BaseXLabel(" ");
        this.lang = new BaseXCombo((BaseXWindow)dialog, LANGS[0]);
        this.lang.setSelectedItem(opts.get(StaticOptions.LANG));
        this.creds = new BaseXLabel(" ");
        this.add(new BaseXLabel(String.valueOf(Text.DATABASE_PATH) + ":", true, true));
        BaseXBack p = new BaseXBack(new TableLayout(1, 2, 8, 0));
        p.add(this.dbPath);
        p.add(this.dbButton);
        this.add(p);
        this.add(new BaseXLabel(String.valueOf(Text.REPOSITORY_PATH) + ":", true, true));
        p = new BaseXBack(new TableLayout(1, 2, 8, 0));
        p.add(this.repoPath);
        p.add(this.repoButton);
        this.add(p);
        p = new BaseXBack(new TableLayout(2, 2, 24, 0)).border(0);
        p.add(new BaseXLabel(String.valueOf(Text.LIMITS) + ":", true, true).border(8, 0, 8, 0));
        p.add(new BaseXLabel(String.valueOf(Text.GUI_INTERACTIONS) + ":", true, true).border(8, 0, 8, 0));
        BaseXBack pp = new BaseXBack(new TableLayout(4, 1, 0, 0)).border(0);
        BaseXBack ppp = new BaseXBack(new TableLayout(1, 2, 12, 0)).border(0);
        ppp.add(this.maxResults);
        ppp.add(this.labelResults);
        pp.add(new BaseXLabel(String.valueOf(Text.MAX_NO_OF_HITS) + ":"));
        pp.add(ppp);
        ppp = new BaseXBack(new TableLayout(1, 2, 12, 0)).border(0);
        ppp.add(this.maxText);
        ppp.add(this.labelText);
        pp.add(new BaseXLabel(String.valueOf(Text.SIZE_TEXT_RESULTS) + ":"));
        pp.add(ppp);
        p.add(pp);
        pp = new BaseXBack(new TableLayout(1, 1, 0, 0)).border(0);
        pp.add(this.mousefocus);
        p.add(pp);
        this.add(p);
        this.add(new BaseXLabel(String.valueOf(Text.LANGUAGE_RESTART) + ":", true, true).border(8, 0, 8, 0));
        p = new BaseXBack(new TableLayout(1, 2, 12, 0));
        p.add(this.lang);
        p.add(this.creds);
        this.add(p);
    }

    private static int sliderIndex(int value, int[] values) {
        int hl = values.length - 1;
        int i = -1;
        while (++i < hl && values[i] < value) {
        }
        return i;
    }

    static String creds(String lng) {
        int ll = LANGS[0].length;
        int l = 0;
        while (l < ll) {
            if (LANGS[0][l].equals(lng)) {
                return LANGS[1][l];
            }
            ++l;
        }
        return "";
    }

    boolean action(Object source) {
        this.mousefocus.assign();
        StaticOptions opts = this.gui.context.soptions;
        if (source == this.dbPath || source == this.dbButton) {
            String dbpath = this.dbPath.getText();
            if (!opts.get(StaticOptions.DBPATH).equals(dbpath) && this.gui.context.data() != null) {
                Close.close(this.gui.context);
                this.gui.notify.init();
            }
            opts.set(StaticOptions.DBPATH, dbpath);
        } else if (source == this.repoPath || source == this.repoButton) {
            this.gui.context.repo.reset();
            opts.set(StaticOptions.REPOPATH, this.repoPath.getText());
        }
        opts.set(StaticOptions.LANG, this.lang.getSelectedItem());
        this.gui.gopts.set(GUIOptions.MAXTEXT, MAXTEXT[this.maxText.getValue()]);
        this.gui.gopts.set(GUIOptions.MAXRESULTS, MAXRESULTS[this.maxResults.getValue()]);
        this.creds.setText(String.valueOf(Text.TRANSLATION) + ": " + DialogGeneralPrefs.creds(this.lang.getSelectedItem()));
        int mr = MAXRESULTS[this.maxResults.getValue()];
        this.labelResults.setText(mr == Integer.MAX_VALUE ? Text.ALL : new DecimalFormat("#,###,###").format(mr));
        int mt = MAXTEXT[this.maxText.getValue()];
        this.labelText.setText(mt == Integer.MAX_VALUE ? Text.ALL : Performance.format(mt));
        return true;
    }
}

