/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.gui.GUIOptions;
import org.basex.query.func.Function;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

public final class ViewData {
    private ViewData() {
    }

    public static boolean leaf(GUIOptions opts, Data data, int pre) {
        int kind = data.kind(pre);
        if (kind == 3) {
            return true;
        }
        boolean atts = opts.get(GUIOptions.MAPATTS);
        int last = pre + (atts ? 1 : data.attSize(pre, kind));
        return last == data.meta.size || data.parent(pre, kind) >= data.parent(last, data.kind(last));
    }

    public static byte[] path(Data data, int pre) {
        if (data == null || pre >= data.meta.size) {
            return Token.EMPTY;
        }
        int p = pre;
        int k = data.kind(p);
        IntList il = new IntList();
        while (k != 0) {
            il.add(p);
            p = data.parent(p, k);
            k = data.kind(p);
        }
        byte[] doc = ViewData.text(data, p, true);
        TokenBuilder tb = new TokenBuilder();
        tb.add(Function._DB_OPEN.args(data.meta.name, Token.string(doc)).substring(1));
        int i = il.size() - 1;
        while (i >= 0) {
            tb.add(47).add(ViewData.text(data, il.get(i), true));
            --i;
        }
        return tb.finish();
    }

    public static byte[] text(Data data, int pre, boolean compact) {
        int kind = data.kind(pre);
        switch (kind) {
            case 1: {
                return data.name(pre, kind);
            }
            case 0: {
                return data.text(pre, true);
            }
            case 2: {
                return compact ? DataText.TEXT : data.text(pre, true);
            }
            case 4: {
                return compact ? DataText.COMMENT : data.text(pre, true);
            }
            case 5: {
                return compact ? DataText.PI : data.text(pre, true);
            }
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(DataText.ATT);
        tb.add(data.name(pre, kind));
        if (!compact) {
            tb.add(DataText.ATT1);
            tb.add(data.text(pre, false));
            tb.add(DataText.ATT2);
        }
        return tb.finish();
    }

    public static byte[] name(GUIOptions opts, Data data, int pre) {
        byte[] att;
        int id;
        if (data.kind(pre) == 1 && (id = ViewData.nameID(data)) != 0 && opts.get(GUIOptions.SHOWNAME).booleanValue() && (att = data.attValue(id, pre)) != null) {
            return att;
        }
        return ViewData.text(data, pre, true);
    }

    public static int nameID(Data data) {
        return data.attrNames.id(DataText.T_NAME);
    }

    public static int sizeID(Data data) {
        return data.attrNames.id(DataText.T_SIZE);
    }

    public static int parent(Data data, int pre) {
        return data.parent(pre, data.kind(pre));
    }

    public static int size(Data data, int pre) {
        return data.size(pre, data.kind(pre));
    }
}

