/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import org.basex.core.Text;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.GUIWorker;
import org.basex.gui.view.editor.EditorArea;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;

final class ProjectFilter
extends BaseXBack {
    private final BaseXCombo filesFilter;
    private final BaseXCombo contentsFilter;
    private final ProjectView view;
    private String fileFilter = "";
    private String contentFilter = "";

    ProjectFilter(ProjectView view) {
        this.view = view;
        this.layout(new BorderLayout(0, 2));
        this.filesFilter = new BaseXCombo((BaseXWindow)view.gui, true, new String[0]).history(GUIOptions.PROJFILES, view.gui.gopts);
        this.filesFilter.addFocusListener(view.lastfocus);
        this.contentsFilter = new BaseXCombo((BaseXWindow)view.gui, true, new String[0]).history(GUIOptions.PROJCONTS, view.gui.gopts);
        this.contentsFilter.hint(String.valueOf(Text.FIND_CONTENTS) + "...");
        this.contentsFilter.addFocusListener(view.lastfocus);
        this.add((Component)this.filesFilter, "North");
        this.add((Component)this.contentsFilter, "Center");
        this.addKeyListener(this.filesFilter);
        this.addKeyListener(this.contentsFilter);
        this.refreshLayout();
    }

    void refresh(boolean force) {
        boolean filter;
        String files = this.filesFilter.getText();
        String contents = this.contentsFilter.getText();
        if (!force && this.fileFilter.equals(files) && this.contentFilter.equals(contents)) {
            return;
        }
        this.fileFilter = files;
        this.contentFilter = contents;
        boolean bl = filter = !files.isEmpty() || !contents.isEmpty();
        if (filter) {
            this.filter(files, contents);
        }
        this.view.showList(filter);
    }

    void find(EditorArea ea) {
        String string = ea.searchString();
        if (!string.isEmpty()) {
            this.contentsFilter.setText(string);
            if (ea.opened()) {
                String pattern;
                String name = ea.file().name();
                int i = name.lastIndexOf(46);
                String file = this.filesFilter.getText();
                String string2 = pattern = file.isEmpty() ? this.view.gui.gopts.get(GUIOptions.FILES) : file;
                if (i != -1 && !pattern.contains("*") && !pattern.contains("?") || !Pattern.compile(IOFile.regex(pattern)).matcher(name).matches()) {
                    this.filesFilter.setText(String.valueOf('*') + name.substring(i));
                }
            }
            this.refresh(false);
        }
        this.contentsFilter.requestFocusInWindow();
    }

    void refreshLayout() {
        String filter = this.view.gui.gopts.get(GUIOptions.FILES).trim();
        this.filesFilter.hint(filter.isEmpty() ? String.valueOf(Text.FIND_FILES) + "..." : filter);
    }

    private void filter(final String files, final String contents) {
        this.filesFilter.setCursor(GUIConstants.CURSORWAIT);
        this.contentsFilter.setCursor(GUIConstants.CURSORWAIT);
        this.view.list.setCursor(GUIConstants.CURSORWAIT);
        new GUIWorker<String[]>(){

            @Override
            protected String[] doInBackground() throws Exception {
                String pattern = files.isEmpty() ? ((ProjectFilter)ProjectFilter.this).view.gui.gopts.get(GUIOptions.FILES) : files;
                return ((ProjectFilter)ProjectFilter.this).view.files.filter(pattern, contents, ((ProjectFilter)ProjectFilter.this).view.root.file);
            }

            @Override
            protected void done(String[] list) {
                ((ProjectFilter)ProjectFilter.this).view.list.setElements(list, contents);
                ProjectFilter.this.filesFilter.setCursor(GUIConstants.CURSORTEXT);
                ProjectFilter.this.contentsFilter.setCursor(GUIConstants.CURSORTEXT);
                ((ProjectFilter)ProjectFilter.this).view.list.setCursor(GUIConstants.CURSORARROW);
            }
        }.execute();
    }

    private void addKeyListener(final BaseXCombo combo) {
        combo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (combo.isPopupVisible()) {
                    return;
                }
                if (BaseXKeys.NEXTLINE.is(e) || BaseXKeys.PREVLINE.is(e) || BaseXKeys.NEXTPAGE.is(e) || BaseXKeys.PREVPAGE.is(e)) {
                    ((ProjectFilter)ProjectFilter.this).view.list.dispatchEvent(e);
                } else {
                    GUIPopupCmd[] gUIPopupCmdArray = ((ProjectFilter)ProjectFilter.this).view.list.commands;
                    int n = ((ProjectFilter)ProjectFilter.this).view.list.commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GUIPopupCmd cmd = gUIPopupCmdArray[n2];
                        if (cmd != null) {
                            BaseXKeys[] baseXKeysArray = cmd.shortcuts();
                            int n3 = baseXKeysArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                BaseXKeys sc = baseXKeysArray[n4];
                                if (sc.is(e)) {
                                    cmd.execute(((ProjectFilter)ProjectFilter.this).view.gui);
                                    e.consume();
                                    return;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ProjectFilter.this.refresh(false);
            }
        });
    }
}

