/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class DataInput
extends BufferInput {
    public DataInput(IO io) throws IOException {
        super(io);
    }

    public boolean readBool() throws IOException {
        return this.read() == 1;
    }

    public byte[] readToken() throws IOException {
        int l = this.readNum();
        if (l == 0) {
            return Token.EMPTY;
        }
        byte[] tmp = new byte[l];
        int i = 0;
        while (i < l) {
            tmp[i] = (byte)this.read();
            ++i;
        }
        return tmp;
    }

    public double readDouble() throws IOException {
        return Token.toDouble(this.readToken());
    }

    public IntList readDiffs() throws IOException {
        int[] tmp = new int[this.readNum()];
        int al = tmp.length;
        int a = 0;
        while (a < al) {
            tmp[a] = (a == 0 ? 0 : tmp[a - 1]) + this.readNum();
            ++a;
        }
        return new IntList(tmp);
    }

    public int[] readNums() throws IOException {
        return this.readNums(this.readNum());
    }

    private int[] readNums(int s) throws IOException {
        int[] tmp = new int[s];
        int a = 0;
        while (a < s) {
            tmp[a] = this.readNum();
            ++a;
        }
        return tmp;
    }

    public byte[][] readTokens() throws IOException {
        int l = this.readNum();
        byte[][] tmp = new byte[l][];
        int i = 0;
        while (i < l) {
            tmp[i] = this.readToken();
            ++i;
        }
        return tmp;
    }

    public int readNum() throws IOException {
        int v = this.read();
        if (v == -1) {
            return 0;
        }
        switch ((v & 0xC0) >>> 6) {
            case 0: {
                return v;
            }
            case 1: {
                return ((v & 0x3F) << 8) + this.read();
            }
            case 2: {
                return ((v & 0x3F) << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
            }
        }
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public long[] readLongs(int s) throws IOException {
        long[] tmp = new long[s];
        int a = 0;
        while (a < s) {
            tmp[a] = this.read8();
            ++a;
        }
        return tmp;
    }

    private long read8() throws IOException {
        return ((long)this.read() << 56) + ((long)(this.read() & 0xFF) << 48) + ((long)(this.read() & 0xFF) << 40) + ((long)(this.read() & 0xFF) << 32) + ((long)(this.read() & 0xFF) << 24) + (long)((this.read() & 0xFF) << 16) + (long)((this.read() & 0xFF) << 8) + (long)(this.read() & 0xFF);
    }
}

