/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.IOFile;
import org.basex.io.out.BufferOutput;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class DataOutput
extends OutputStream {
    private final OutputStream os;
    private long size;

    public DataOutput(OutputStream os) {
        this.os = os;
    }

    public DataOutput(IOFile db) throws IOException {
        this(db, 4096);
    }

    public DataOutput(IOFile db, int bufs) throws IOException {
        this.os = new BufferOutput(new FileOutputStream(db.file()), bufs);
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        ++this.size;
    }

    public void writeBool(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    public int writeToken(byte[] tok) throws IOException {
        int s = this.writeNum(tok.length);
        this.writeBytes(tok);
        return s + tok.length;
    }

    public int writeDouble(double num) throws IOException {
        return this.writeToken(Token.token(num));
    }

    public void writeTokens(byte[][] array) throws IOException {
        this.writeNum(array.length);
        byte[][] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] a = byArray[n2];
            this.writeToken(a != null ? a : Token.EMPTY);
            ++n2;
        }
    }

    public void writeDiffs(IntList array) throws IOException {
        int al = array.size();
        this.writeNum(al);
        int c = 0;
        int a = 0;
        while (a < al) {
            int t = array.get(a);
            this.writeNum(t - c);
            c = t;
            ++a;
        }
    }

    public void writeNums(int[] array) throws IOException {
        this.writeNum(array.length);
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            this.writeNum(a);
            ++n2;
        }
    }

    public int writeNum(int v) throws IOException {
        if (v < 0 || v > 0x3FFFFFFF) {
            this.write(192);
            this.write(v >>> 24);
            this.write(v >>> 16);
            this.write(v >>> 8);
            this.write(v);
            return 5;
        }
        if (v > 16383) {
            this.write(v >>> 24 | 0x80);
            this.write(v >>> 16);
            this.write(v >>> 8);
            this.write(v);
            return 4;
        }
        if (v > 63) {
            this.write(v >>> 8 | 0x40);
            this.write(v);
            return 2;
        }
        this.write(v);
        return 1;
    }

    public void writeLongs(long[] array) throws IOException {
        this.writeNum(array.length);
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long a = lArray[n2];
            this.write8(a);
            ++n2;
        }
    }

    public void write1(int v) throws IOException {
        this.write(v);
    }

    public void write2(int v) throws IOException {
        this.write(v >>> 8);
        this.write(v);
    }

    public void write4(int v) throws IOException {
        this.write(v >>> 24);
        this.write(v >>> 16);
        this.write(v >>> 8);
        this.write(v);
    }

    public void write5(long v) throws IOException {
        this.write((byte)(v >>> 32));
        this.write((byte)(v >>> 24));
        this.write((byte)(v >>> 16));
        this.write((byte)(v >>> 8));
        this.write((byte)v);
    }

    private void write8(long v) throws IOException {
        this.write((byte)(v >>> 56));
        this.write((byte)(v >>> 48));
        this.write((byte)(v >>> 40));
        this.write((byte)(v >>> 32));
        this.write((byte)(v >>> 24));
        this.write((byte)(v >>> 16));
        this.write((byte)(v >>> 8));
        this.write((byte)v);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.write(b);
            ++n2;
        }
    }

    public long size() {
        return this.size;
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

