/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.core.jobs.Job;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.StaticContext;
import org.basex.query.iter.Iter;
import org.basex.query.util.UriResolver;
import org.basex.query.value.Value;
import org.basex.query.value.node.FDoc;

public final class QueryProcessor
extends Job
implements Closeable {
    private static final Pattern LIBMOD_PATTERN = Pattern.compile("^(xquery( version ['\"].*?['\"])?( encoding ['\"].*?['\"])? ?; ?)?module namespace.*");
    public final StaticContext sc;
    public final QueryContext qc;
    private final String query;
    private boolean parsed;

    public QueryProcessor(String query, Context ctx) {
        this(query, null, ctx);
    }

    public QueryProcessor(String query, String uri, Context ctx) {
        this.query = query;
        this.qc = this.pushJob(new QueryContext(ctx));
        this.sc = new StaticContext(this.qc);
        this.sc.baseURI(uri);
    }

    public void parse() throws QueryException {
        if (this.parsed) {
            return;
        }
        try {
            this.qc.parseMain(this.query, null, this.sc);
        }
        finally {
            this.parsed = true;
            this.updating = this.qc.updating;
        }
    }

    public void compile() throws QueryException {
        this.parse();
        this.qc.compile();
    }

    public Iter iter() throws QueryException {
        this.parse();
        return this.qc.iter();
    }

    public Value value() throws QueryException {
        return this.iter().value(this.qc);
    }

    public Value cache(int max) throws QueryException {
        this.parse();
        return this.qc.cache(max);
    }

    public QueryProcessor bind(String name, Object value, String type) throws QueryException {
        this.qc.bind(name, value, type, this.sc);
        return this;
    }

    public QueryProcessor bind(String name, Object value) throws QueryException {
        return this.bind(name, value, null);
    }

    public QueryProcessor bind(String name, Value value) throws QueryException {
        this.qc.bind(name, value, this.sc);
        return this;
    }

    public QueryProcessor context(Object value) throws QueryException {
        return this.context(value, null);
    }

    public QueryProcessor context(Value value) {
        this.qc.context(value, this.sc);
        return this;
    }

    public QueryProcessor http(Object value) {
        this.qc.http(value);
        return this;
    }

    public QueryProcessor context(Object value, String type) throws QueryException {
        this.qc.context(value, type, this.sc);
        return this;
    }

    public QueryProcessor namespace(String prefix, String uri) throws QueryException {
        this.sc.namespace(prefix, uri);
        return this;
    }

    public QueryProcessor uriResolver(UriResolver resolver) {
        this.sc.resolver = resolver;
        return this;
    }

    public Serializer getSerializer(OutputStream os) throws IOException, QueryException {
        this.compile();
        try {
            return Serializer.get(os, this.qc.serParams()).sc(this.sc);
        }
        catch (QueryIOException ex) {
            throw ex.getCause();
        }
    }

    public void module(String uri, String file) {
        this.qc.modDeclared.put(uri, file);
    }

    public String query() {
        return this.query;
    }

    @Override
    public void close() {
        this.qc.close();
    }

    @Override
    public void addLocks() {
        this.qc.addLocks();
    }

    public int updates() {
        return this.updating ? this.qc.updates().size() : 0;
    }

    public String info() {
        return this.qc.info();
    }

    public static boolean isLibrary(String qu) {
        return LIBMOD_PATTERN.matcher(QueryProcessor.removeComments(qu, 80)).matches();
    }

    public static String removeComments(String qu, int max) {
        StringBuilder sb = new StringBuilder();
        int m = 0;
        boolean s = false;
        int cl = qu.length();
        int c = 0;
        while (c < cl && sb.length() < max) {
            char ch = qu.charAt(c);
            if (ch != '\r') {
                if (ch == '(' && c + 1 < cl && qu.charAt(c + 1) == ':') {
                    if (m == 0 && !s) {
                        sb.append(' ');
                        s = true;
                    }
                    ++m;
                    ++c;
                } else if (m != 0 && ch == ':' && c + 1 < cl && qu.charAt(c + 1) == ')') {
                    --m;
                    ++c;
                } else if (m == 0) {
                    if (ch > ' ') {
                        sb.append(ch);
                    } else if (!s) {
                        sb.append(' ');
                    }
                    s = ch <= ' ';
                }
            }
            ++c;
        }
        if (sb.length() >= max) {
            sb.append("...");
        }
        return sb.toString().trim();
    }

    public FDoc plan() {
        return new FDoc().add(this.qc.plan());
    }

    public String toString() {
        return this.query;
    }
}

