/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.array.ArrayFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.array.Array;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class ArrayJoin
extends ArrayFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr expr = this.exprs[0];
        if (expr.seqType().zeroOrOne()) {
            Item item = expr.item(qc, this.info);
            return item == null ? Array.empty() : this.toArray(item);
        }
        Iter iter = expr.iter(qc);
        Item item = iter.next();
        if (item == null) {
            return Array.empty();
        }
        Array fst = this.toArray(item);
        item = iter.next();
        if (item == null) {
            return fst;
        }
        Array snd = this.toArray(item);
        item = iter.next();
        if (item == null) {
            return fst.concat(snd);
        }
        ArrayBuilder builder = new ArrayBuilder().append(fst).append(snd);
        do {
            builder.append(this.toArray(item));
        } while ((item = qc.next(iter)) != null);
        return builder.freeze();
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Type type = this.exprs[0].seqType().type;
        if (type instanceof ArrayType) {
            this.exprType.assign(type);
        }
        return this;
    }
}

