/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;

public class FileWriteBinary
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        return this.write(false, qc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final synchronized Item write(boolean append, QueryContext qc) throws QueryException, IOException {
        Path path = this.checkParentDir(this.toPath(0, qc));
        Bin bin = this.toBin(this.exprs[1], qc);
        if (this.exprs.length == 2) {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                BufferOutput out = new BufferOutput(new FileOutputStream(path.toFile(), append));
                try {
                    try (BufferInput in = bin.input(this.info);){
                        int b;
                        while ((b = in.read()) != -1) {
                            out.write(b);
                        }
                    }
                    if (out == null) return null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
                return null;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        long off = this.toLong(this.exprs[2], qc);
        Throwable throwable = null;
        Object var8_15 = null;
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");){
            long dlen = raf.length();
            if (off < 0L || off > dlen) {
                throw QueryError.FILE_OUT_OF_RANGE_X_X.get(this.info, off, dlen);
            }
            raf.seek(off);
            raf.write(bin.binary(this.info));
            return null;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            } else {
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

