/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.util.format.FormatUtil;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.hash.IntSet;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class DecFormatter
extends FormatUtil {
    private final byte[] digits;
    private final byte[] actives;
    public final int zero;
    public byte[] inf;
    public byte[] nan;
    public int pattern;
    public int decimal;
    public int exponent;
    public int grouping;
    public int optional;
    public int minus;
    public int percent;
    public int permille;

    public DecFormatter(TokenMap map, InputInfo info) throws QueryException {
        int z;
        block39: {
            this.inf = Token.token("Infinity");
            this.nan = Token.token("NaN");
            this.pattern = 59;
            this.decimal = 46;
            this.exponent = 101;
            this.grouping = 44;
            this.optional = 35;
            this.minus = 45;
            this.percent = 37;
            this.permille = 8240;
            z = 48;
            if (map == null) break block39;
            block22: for (byte[] key : map) {
                byte[] v;
                String k;
                block40: {
                    k = Token.string(key);
                    v = map.get(key);
                    if (k.equals("infinity")) {
                        this.inf = v;
                        continue;
                    }
                    if (k.equals("NaN")) {
                        this.nan = v;
                        continue;
                    }
                    if (v.length == 0 || Token.cl(v, 0) != v.length) break block40;
                    int cp = Token.cp(v, 0);
                    switch (k) {
                        case "decimal-separator": {
                            this.decimal = cp;
                            break;
                        }
                        case "grouping-separator": {
                            this.grouping = cp;
                            break;
                        }
                        case "exponent-separator": {
                            this.exponent = cp;
                            break;
                        }
                        case "pattern-separator": {
                            this.pattern = cp;
                            break;
                        }
                        case "minus-sign": {
                            this.minus = cp;
                            break;
                        }
                        case "digit": {
                            this.optional = cp;
                            break;
                        }
                        case "percent": {
                            this.percent = cp;
                            break;
                        }
                        case "per-mille": {
                            this.permille = cp;
                            break;
                        }
                        case "zero-digit": {
                            z = DecFormatter.zeroes(cp);
                            if (z == -1) {
                                throw QueryError.INVDECFORM_X_X.get(info, k, v);
                            }
                            if (z == cp) continue block22;
                            throw QueryError.INVDECZERO_X.get(info, Character.valueOf((char)cp));
                        }
                    }
                    continue;
                }
                throw QueryError.INVDECSINGLE_X_X.get(info, k, v);
            }
        }
        this.zero = z;
        IntSet is = new IntSet();
        int i = 0;
        while (i < 10) {
            is.add(this.zero + i);
            ++i;
        }
        int[] ss = new int[]{this.decimal, this.grouping, this.exponent, this.percent, this.permille, this.optional, this.pattern};
        Object object = ss;
        int n = ss.length;
        int v = 0;
        while (v < n) {
            Object s = object[v];
            if (!is.add((int)s)) {
                throw QueryError.DUPLDECFORM_X.get(info, Character.valueOf((char)s));
            }
            ++v;
        }
        TokenBuilder tb = new TokenBuilder();
        int i2 = 0;
        while (i2 < 10) {
            tb.add(this.zero + i2);
            ++i2;
        }
        this.digits = tb.toArray();
        this.actives = tb.add(this.decimal).add(this.exponent).add(this.grouping).add(this.optional).finish();
    }

    public byte[] format(InputInfo info, ANum number, byte[] picture) throws QueryException {
        TokenList tl = new TokenList();
        byte[] pic = picture;
        int i = Token.indexOf(pic, this.pattern);
        if (i == -1) {
            tl.add(pic);
        } else {
            tl.add(Token.substring(pic, 0, i));
            pic = Token.substring(pic, i + Token.cl(pic, i));
            if (Token.contains(pic, this.pattern)) {
                throw QueryError.PICNUM_X.get(info, new Object[]{picture});
            }
            tl.add(pic);
        }
        byte[][] patterns = (byte[][])tl.finish();
        if (!this.checkSyntax(patterns)) {
            throw QueryError.PICNUM_X.get(info, new Object[]{picture});
        }
        Picture[] pics = this.analyze(patterns);
        return this.format(number, pics, info);
    }

    private boolean checkSyntax(byte[][] patterns) {
        byte[][] byArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] pt = byArray[n2];
            boolean frac = false;
            boolean act = false;
            boolean expAct = false;
            boolean exp = false;
            boolean digMant = false;
            boolean optInt = false;
            boolean optFrac = false;
            boolean per = false;
            int last = 0;
            int pl = pt.length;
            int i = 0;
            while (i < pl) {
                int ch = DecFormatter.ch(pt, i);
                int cl = Token.cl(pt, i);
                boolean digit = Token.contains(this.digits, ch);
                boolean active = Token.contains(this.actives, ch);
                boolean expon = false;
                if (ch == this.decimal) {
                    if (frac) {
                        return false;
                    }
                    frac = true;
                } else if (ch == this.grouping) {
                    if (i == 0 && frac || last == this.decimal || (i + cl < pl ? DecFormatter.ch(pt, i + cl) == this.decimal : !frac)) {
                        return false;
                    }
                    if (last == this.grouping) {
                        return false;
                    }
                } else if (ch == this.exponent) {
                    if (act && this.containsActive(pt, i + cl)) {
                        if (exp) {
                            return false;
                        }
                        expon = true;
                    } else {
                        active = false;
                    }
                } else if (ch == this.percent || ch == this.permille) {
                    if (per) {
                        return false;
                    }
                    per = true;
                } else if (ch == this.optional) {
                    if (frac) {
                        optFrac = true;
                    } else {
                        if (digMant) {
                            return false;
                        }
                        optInt = true;
                    }
                } else if (digit && !exp) {
                    if (optFrac) {
                        return false;
                    }
                    digMant = true;
                }
                if (active) {
                    if (exp) {
                        if (!digit) {
                            return false;
                        }
                        expAct = true;
                    }
                    act = true;
                } else if (act && this.containsActive(pt, i + cl)) {
                    return false;
                }
                last = ch;
                if (expon) {
                    exp = true;
                }
                i += cl;
            }
            if (!(optInt || optFrac || digMant)) {
                return false;
            }
            if (per && exp) {
                return false;
            }
            if (exp && !expAct) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Picture[] analyze(byte[][] patterns) {
        int picL = patterns.length;
        Picture[] pics = new Picture[picL];
        int p = 0;
        while (p < picL) {
            byte[] pt = patterns[p];
            Picture pic = new Picture();
            boolean frac = false;
            boolean act = false;
            boolean exp = false;
            int optInt = 0;
            int optFrac = 0;
            int pl = pt.length;
            int i = 0;
            while (i < pl) {
                int ch = DecFormatter.ch(pt, i);
                int cl = Token.cl(pt, i);
                boolean active = Token.contains(this.actives, ch);
                if (ch == this.decimal) {
                    frac = true;
                    act = false;
                } else if (ch == this.optional) {
                    if (frac) {
                        ++optFrac;
                    } else {
                        ++optInt;
                    }
                } else if (ch == this.exponent) {
                    if (act && this.containsActive(pt, i + cl)) {
                        exp = true;
                    } else {
                        active = false;
                    }
                } else if (ch == this.grouping) {
                    if (!frac) {
                        pic.groupInt.add(pic.minInt + optInt);
                    }
                } else if (Token.contains(this.digits, ch)) {
                    if (exp) {
                        Picture picture = pic;
                        picture.minExp = picture.minExp + 1;
                    } else if (frac) {
                        Picture picture = pic;
                        picture.minFrac = picture.minFrac + 1;
                    } else {
                        Picture picture = pic;
                        picture.minInt = picture.minInt + 1;
                    }
                }
                if (active) {
                    act = true;
                } else {
                    Picture picture = pic;
                    picture.pc = picture.pc | ch == this.percent;
                    Picture picture2 = pic;
                    picture2.pm = picture2.pm | ch == this.permille;
                    (frac || act ? pic.suffix : pic.prefix).add(ch);
                }
                i += cl;
            }
            IntList ipgp = pic.groupInt;
            int igl = ipgp.size();
            int g = 0;
            while (g < igl) {
                ipgp.set(g, pic.minInt + optInt - ipgp.get(g));
                ++g;
            }
            if (igl > 1) {
                boolean reg = true;
                int i2 = ipgp.get(igl - 1);
                int g2 = igl - 2;
                while (g2 >= 0) {
                    reg &= i2 * igl == ipgp.get(g2);
                    --g2;
                }
                if (reg) {
                    pic.groupInt.reset();
                    pic.groupInt.add(i2);
                }
            }
            pic.scaling = pic.minInt;
            pic.maxFrac = optFrac + pic.minFrac;
            if (pic.minInt == 0 && pic.maxFrac == 0) {
                if (exp) {
                    pic.minFrac = 1;
                    pic.maxFrac = 1;
                } else {
                    pic.minInt = 1;
                }
            }
            if (exp && pic.minInt == 0 && optInt > 0) {
                pic.minInt = 1;
            }
            if (pic.minInt == 0 && pic.minFrac == 0) {
                pic.minFrac = 1;
            }
            pics[p] = pic;
            ++p;
        }
        return pics;
    }

    private boolean containsActive(byte[] pt, int i) {
        int pl = pt.length;
        int p = i;
        while (p < pl) {
            if (Token.contains(this.actives, DecFormatter.ch(pt, p))) {
                return true;
            }
            p += Token.cl(pt, p);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] format(ANum item, Picture[] pics, InputInfo ii) throws QueryException {
        block26: {
            block27: {
                block28: {
                    block25: {
                        d = item.dbl(ii);
                        if (Double.isNaN(d)) {
                            return this.nan;
                        }
                        neg = d < 0.0 || d == 0.0 && Double.doubleToLongBits(d) == -9223372036854775808L;
                        pic = pics[neg != false && pics.length == 2 ? 1 : 0];
                        res = new IntList();
                        intgr = new IntList();
                        fract = new IntList();
                        exp = 0;
                        num = item;
                        if (Picture.access$8(pic)) {
                            num = (ANum)Calc.MULT.eval(num, Int.get(100L), ii);
                        }
                        if (Picture.access$10(pic)) {
                            num = (ANum)Calc.MULT.eval(num, Int.get(1000L), ii);
                        }
                        if (!Double.isInfinite(num.dbl(ii))) break block25;
                        intgr.add(new TokenParser(this.inf).toArray());
                        break block26;
                    }
                    if (Picture.access$3(pic) == 0 || d == 0.0) break block27;
                    dec = num.dec(ii).abs().stripTrailingZeros();
                    scl = 0;
                    if (dec.compareTo(BigDecimal.ONE) < 0) ** GOTO lbl28
                    scl = dec.setScale(0, RoundingMode.HALF_DOWN).precision();
                    break block28;
lbl-1000:
                    // 1 sources

                    {
                        dec = dec.multiply(BigDecimal.TEN);
                        --scl;
lbl28:
                        // 2 sources

                        ** while (dec.compareTo((BigDecimal)BigDecimal.ONE) < 0)
                    }
lbl29:
                    // 1 sources

                    ++scl;
                }
                exp = scl - Picture.access$17(pic);
                if (exp != 0) {
                    n = BigDecimal.TEN.pow(Math.abs(exp));
                    num = (ANum)Calc.MULT.eval(num, Dec.get(exp > 0 ? BigDecimal.ONE.divide(n, MathContext.DECIMAL64) : n), ii);
                }
            }
            if ((s = ((num = num.round(Picture.access$16(pic), true).abs()) instanceof Dbl != false || num instanceof Flt != false ? Dec.get(BigDecimal.valueOf(num.dbl(ii))) : num).toString()).startsWith("0")) {
                s = s.substring(1);
            }
            fracSep = s.indexOf(46);
            sl = s.length();
            i = il = fracSep == -1 ? sl : fracSep;
            while (i < Picture.access$2(pic)) {
                intgr.add(this.zero);
                ++i;
            }
            i = 0;
            while (i < il) {
                intgr.add(this.zero + s.charAt(i) - 48);
                ++i;
            }
            gil = Picture.access$1(pic).size();
            if (gil == 1 && Picture.access$1(pic).get(0) > 0) {
                i = intgr.size() - 1;
                while (i > 0) {
                    if (i % Picture.access$1(pic).get(0) == 0) {
                        intgr.insert(intgr.size() - i, new int[]{this.grouping});
                    }
                    --i;
                }
            } else {
                g = 0;
                while (g < gil) {
                    pos = intgr.size() - Picture.access$1(pic).get(g);
                    if (pos > 0) {
                        intgr.insert(pos, new int[]{this.grouping});
                    }
                    ++g;
                }
            }
            v0 = fl = fracSep == -1 ? 0 : sl - il - 1;
            if (fl != 0) {
                i = fracSep + 1;
                while (i < sl) {
                    fract.add(this.zero + s.charAt(i) - 48);
                    ++i;
                }
            }
            i = fl;
            while (i < Picture.access$5(pic)) {
                fract.add(this.zero);
                ++i;
            }
            ul = fract.size();
            p = Picture.access$18(pic).size() - 1;
            while (p >= 0) {
                pos = Picture.access$18(pic).get(p);
                if (pos < ul) {
                    fract.insert(pos, new int[]{this.grouping});
                }
                --p;
            }
        }
        if (neg && pics.length != 2) {
            res.add(this.minus);
        }
        res.add(Picture.access$13(pic).toArray()).add(intgr.finish());
        if (!fract.isEmpty()) {
            res.add(this.decimal).add(fract.finish());
        }
        if (Picture.access$3(pic) != 0) {
            res.add(this.exponent);
            if (exp < 0) {
                res.add(this.minus);
            }
            s = Integer.toString(Math.abs(exp));
            i = sl = s.length();
            while (i < Picture.access$3(pic)) {
                res.add(this.zero);
                ++i;
            }
            i = 0;
            while (i < sl) {
                res.add(this.zero + s.charAt(i) - 48);
                ++i;
            }
        }
        res.add(Picture.access$12(pic).toArray());
        return new TokenBuilder(res.finish()).finish();
    }

    private static final class Picture {
        private final IntList prefix = new IntList();
        private final IntList suffix = new IntList();
        private final IntList groupInt = new IntList();
        private final IntList groupFrac = new IntList();
        private int scaling;
        private int minInt;
        private int minFrac;
        private int maxFrac;
        private int minExp;
        private boolean pc;
        private boolean pm;

        private Picture() {
        }

        static /* synthetic */ int access$17(Picture picture) {
            return picture.scaling;
        }

        static /* synthetic */ IntList access$18(Picture picture) {
            return picture.groupFrac;
        }
    }
}

