/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class IntSeq
extends NativeSeq {
    private final long[] values;

    private IntSeq(long[] values, Type type) {
        super(values.length, type);
        this.values = values;
    }

    @Override
    public Int itemAt(long pos) {
        return Int.get(this.values[(int)pos], this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntSeq)) {
            return super.equals(obj);
        }
        IntSeq is = (IntSeq)obj;
        return this.type == is.type && Arrays.equals(this.values, is.values);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        long[] tmp = new long[sz];
        int i = 0;
        while (i < sz) {
            tmp[sz - i - 1] = this.values[i];
            ++i;
        }
        return IntSeq.get(tmp, this.type);
    }

    @Override
    public Object toJava() {
        switch ((AtomType)this.type) {
            case BYT: {
                byte[] t1 = new byte[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t1[s] = (byte)this.values[s];
                    ++s;
                }
                return t1;
            }
            case SHR: 
            case UBY: {
                short[] t2 = new short[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t2[s] = (short)this.values[s];
                    ++s;
                }
                return t2;
            }
            case INT: 
            case USH: {
                int[] t3 = new int[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t3[s] = (int)this.values[s];
                    ++s;
                }
                return t3;
            }
        }
        return this.values;
    }

    public long[] values() {
        return this.values;
    }

    public static Value get(long[] values, Type type) {
        return values.length == 0 ? Empty.SEQ : (values.length == 1 ? Int.get(values[0], type) : new IntSeq(values, type));
    }

    public static Value get(Value[] values, int size, Type type) throws QueryException {
        long[] tmp = new long[size];
        int t = 0;
        Value[] valueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            int vs = (int)value.size();
            if (value instanceof IntSeq) {
                IntSeq seq = (IntSeq)value;
                System.arraycopy(seq.values, 0, tmp, t, vs);
                t += vs;
            } else {
                int v = 0;
                while (v < vs) {
                    tmp[t++] = value.itemAt(v).itr(null);
                    ++v;
                }
            }
            ++n2;
        }
        return IntSeq.get(tmp, type);
    }
}

