/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Arrays;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.tree.BigSeq;
import org.basex.query.value.seq.tree.TreeSeq;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

final class SmallSeq
extends TreeSeq {
    final Item[] elems;

    SmallSeq(Item[] elems, Type type) {
        super(elems.length, type);
        this.elems = elems;
        assert (elems.length >= 2 && elems.length <= 7);
    }

    @Override
    public Item itemAt(long index) {
        return this.elems[(int)index];
    }

    @Override
    public TreeSeq reverse(QueryContext qc) {
        int el = this.elems.length;
        Item[] es = new Item[el];
        int e = 0;
        while (e < el) {
            es[e] = this.elems[el - 1 - e];
            ++e;
        }
        return new SmallSeq(es, this.type);
    }

    @Override
    public TreeSeq insert(long pos, Item value, QueryContext qc) {
        int p = (int)pos;
        int n = this.elems.length;
        Item[] out = new Item[n + 1];
        System.arraycopy(this.elems, 0, out, 0, p);
        out[p] = value;
        System.arraycopy(this.elems, p, out, p + 1, n - p);
        if (n < 7) {
            return new SmallSeq(out, null);
        }
        return new BigSeq(SmallSeq.slice(out, 0, 4), FingerTree.empty(), SmallSeq.slice(out, 4, n + 1), null);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        int p = (int)pos;
        int n = this.elems.length;
        if (n == 2) {
            return this.elems[pos == 0L ? 1 : 0];
        }
        Item[] out = new Item[n - 1];
        System.arraycopy(this.elems, 0, out, 0, p);
        System.arraycopy(this.elems, p + 1, out, p, n - 1 - p);
        return new SmallSeq(out, this.type);
    }

    @Override
    protected Seq subSeq(long offset, long length, QueryContext qc) {
        int o = (int)offset;
        int l = (int)length;
        return new SmallSeq(SmallSeq.slice(this.elems, o, o + l), this.type);
    }

    @Override
    public TreeSeq concat(TreeSeq other) {
        return other.consSmall(this.elems);
    }

    @Override
    public ListIterator<Item> iterator(long start) {
        return new ListIterator<Item>(start){
            private int index;
            {
                this.index = (int)l;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public boolean hasNext() {
                return this.index < SmallSeq.this.elems.length;
            }

            @Override
            public Item next() {
                return SmallSeq.this.elems[this.index++];
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Item previous() {
                return SmallSeq.this.elems[--this.index];
            }

            @Override
            public void set(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void add(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){

            @Override
            public Item get(long i) {
                return SmallSeq.this.elems[(int)i];
            }

            @Override
            public Value value() {
                return SmallSeq.this;
            }

            @Override
            public Value value(QueryContext qc) {
                return this.value();
            }
        };
    }

    @Override
    TreeSeq consSmall(Item[] left) {
        int l = left.length;
        int r = this.elems.length;
        int n = l + r;
        if (Math.min(l, r) >= 4) {
            return new BigSeq(left, FingerTree.empty(), this.elems, null);
        }
        Item[] out = new Item[n];
        System.arraycopy(left, 0, out, 0, l);
        System.arraycopy(this.elems, 0, out, l, r);
        if (n <= 7) {
            return new SmallSeq(out, null);
        }
        int mid = n / 2;
        return new BigSeq(SmallSeq.slice(out, 0, mid), FingerTree.empty(), SmallSeq.slice(out, mid, n), null);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || !(obj instanceof SmallSeq ? !Arrays.equals(this.elems, ((SmallSeq)obj).elems) : !super.equals(obj));
    }
}

