/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobException;
import org.basex.io.out.PrintOutput;
import org.basex.io.out.ServerOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class ServerQuery
extends Job {
    private final String query;
    private final Context ctx;
    private QueryProcessor qp;
    private boolean parsed;
    private String info = "";

    public ServerQuery(String query, Context ctx) {
        this.query = query;
        this.ctx = ctx;
    }

    public void bind(String name, Object value, String type) throws IOException {
        try {
            this.qp().bind(name, value, type);
        }
        catch (QueryException ex) {
            Util.stack(ex);
            throw new BaseXException(ex);
        }
    }

    public void context(Object value, String type) throws IOException {
        try {
            this.qp().context(value, type);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    public String info() {
        return this.info;
    }

    public String parameters() throws IOException {
        this.parse();
        return this.qp.qc.serParams().toString();
    }

    public boolean updating() throws IOException {
        this.parse();
        return this.qp.updating;
    }

    public void execute(OutputStream out, boolean iterative, boolean encode, boolean full) throws IOException {
        try {
            try {
                this.parse();
                this.qp.register(this.ctx);
                Performance perf = this.jc().performance;
                this.qp.compile();
                QueryContext qc = this.qp.qc;
                QueryInfo qi = qc.info;
                qi.compiling = perf.ns();
                Iter iter = this.qp.iter();
                qi.evaluating = perf.ns();
                int c = 0;
                PrintOutput po = PrintOutput.get(encode ? new ServerOutput(out) : out);
                SerializerOptions sopts = full ? SerializerMode.API.get() : qc.serParams();
                Throwable throwable = null;
                Object var13_16 = null;
                try (Serializer ser = Serializer.get(po, sopts);){
                    Item item;
                    while ((item = qc.next(iter)) != null) {
                        if (iterative) {
                            if (full) {
                                po.write(item.xdmInfo());
                            } else {
                                po.write(item.typeId().asByte());
                            }
                            ser.reset();
                            ser.serialize(item);
                            po.flush();
                            out.write(0);
                        } else {
                            ser.serialize(item);
                        }
                        ++c;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                qi.serializing = perf.ns();
                this.info = qi.toString(this.qp, po.size(), c, this.ctx.options.get(MainOptions.QUERYINFO));
            }
            catch (JobException | QueryException ex) {
                throw new BaseXException(ex);
            }
            catch (StackOverflowError ex) {
                Util.debug(ex);
                throw new BaseXException(QueryError.BASEX_OVERFLOW.desc, new Object[0]);
            }
        }
        finally {
            if (this.qp != null) {
                if (this.parsed) {
                    this.qp.close();
                    this.qp.unregister(this.ctx);
                    this.parsed = false;
                }
                this.qp = null;
                this.popJob();
            }
        }
    }

    private void parse() throws IOException {
        if (this.parsed) {
            return;
        }
        Performance perf = new Performance();
        try {
            this.qp().parse();
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
        this.qp.qc.info.parsing = perf.ns();
        this.parsed = true;
    }

    private QueryProcessor qp() {
        if (this.parsed || this.qp == null) {
            this.qp = this.pushJob(new QueryProcessor(this.query, this.ctx));
            this.parsed = false;
        }
        return this.qp;
    }
}

