/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class WordnetStemmer
extends Stemmer {
    private static final String PATTERN = "edu.mit.jwi.%";
    private static final String PATH = "etc/wndict";
    private static final Constructor<?> CTR;
    private static final Method FIND_STEMS;
    private static final Object DICT;
    private Object stemmer;

    static {
        if (Reflect.available(PATTERN, "Dictionary")) {
            CTR = null;
            FIND_STEMS = null;
            DICT = null;
        } else {
            Class<?> dict = Reflect.find(PATTERN, "Dictionary");
            Class<?> wn = Reflect.find(PATTERN, "morph.WordnetStemmer");
            CTR = Reflect.find(wn, Reflect.find(PATTERN, "IDictionary"));
            FIND_STEMS = Reflect.method(wn, "findStems", String.class);
            DICT = WordnetStemmer.newDict(dict);
        }
    }

    private static Object newDict(Class<?> dct) {
        try {
            Constructor<?> ctr = Reflect.find(dct, URL.class);
            Object dict = Reflect.get(ctr, new URL("file", null, PATH));
            return Reflect.invoke(Reflect.method(dct, "open", new Class[0]), dict, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static boolean available() {
        return DICT != null;
    }

    WordnetStemmer() {
    }

    private WordnetStemmer(FTIterator fti) {
        super(fti);
        this.stemmer = Reflect.get(CTR, DICT);
    }

    @Override
    Stemmer get(Language lang, FTIterator fti) {
        return new WordnetStemmer(fti);
    }

    @Override
    public boolean supports(Language lang) {
        return lang.equals(Language.get("en"));
    }

    @Override
    protected byte prec() {
        return 30;
    }

    @Override
    Collection<Language> languages() {
        HashSet<Language> ln = new HashSet<Language>();
        ln.add(Language.get("en"));
        return ln;
    }

    @Override
    protected byte[] stem(byte[] word) {
        List l = (List)Reflect.invoke(FIND_STEMS, this.stemmer, Token.string(word));
        byte[] result = l.isEmpty() ? word : Token.token((String)l.get(0));
        return result.length == 0 ? word : result;
    }
}

