/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntSet;

public final class IntObjMap<E>
extends IntSet {
    private Object[] values = new Object[8];

    public E put(int key, E value) {
        int i = this.put(key);
        Object v = this.values[i];
        this.values[i] = value;
        return (E)v;
    }

    public E get(int key) {
        return (E)this.values[this.id(key)];
    }

    public Iterable<E> values() {
        return new ArrayIterator(this.values, 1, this.size);
    }

    @Override
    protected void rehash(int sz) {
        super.rehash(sz);
        this.values = Array.copy(this.values, new Object[sz]);
    }

    @Override
    public int delete(int key) {
        int i = super.delete(key);
        if (i != 0) {
            this.values[i] = null;
        }
        return i;
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder(Util.className(this)).add(91);
        int i = 1;
        while (i < this.size) {
            tb.add(Integer.toString(this.keys[i])).add(": ").addExt(this.get(this.keys[i]), new Object[0]);
            if (i < this.size - 1) {
                tb.add(",\n\t");
            }
            ++i;
        }
        return tb.add(93).toString();
    }
}

