/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.entity;

import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetableResourceEntity
implements Response.Entity {
    private static final Logger log = LoggerFactory.getLogger(GetableResourceEntity.class);
    private GetableResource resource;
    private Range range;
    private Map<String, String> params;
    private String contentType;

    public GetableResourceEntity(GetableResource resource, Map<String, String> params, String contentType) {
        this(resource, null, params, contentType);
    }

    public GetableResourceEntity(GetableResource resource, Range range, Map<String, String> params, String contentType) {
        this.resource = resource;
        this.range = range;
        this.params = params;
        this.contentType = contentType;
    }

    public GetableResource getResource() {
        return this.resource;
    }

    public Range getRange() {
        return this.range;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void write(Response response, OutputStream outputStream) throws Exception {
        long l = System.currentTimeMillis();
        log.trace("sendContent");
        try {
            this.resource.sendContent(outputStream, this.range, this.params, this.contentType);
            outputStream.flush();
            if (log.isTraceEnabled()) {
                l = System.currentTimeMillis() - l;
                log.trace("sendContent finished in " + l + "ms");
            }
        }
        catch (IOException ex) {
            log.warn("IOException writing to output, probably client terminated connection", (Throwable)ex);
        }
    }
}

