/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11.auth;

import com.bradmcevoy.http.AuthenticationHandler;
import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.FilterChain;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.SecurityManager;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import com.bradmcevoy.http.http11.auth.NonceProvider;
import com.bradmcevoy.http.http11.auth.SecurityManagerBasicAuthHandler;
import com.bradmcevoy.http.http11.auth.SecurityManagerDigestAuthenticationHandler;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreAuthenticationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PreAuthenticationFilter.class);
    private static final ThreadLocal<Request> tlRequest = new ThreadLocal();
    private final Http11ResponseHandler responseHandler;
    private final List<AuthenticationHandler> authenticationHandlers;

    public static Request getCurrentRequest() {
        return tlRequest.get();
    }

    public PreAuthenticationFilter(Http11ResponseHandler responseHandler, List<AuthenticationHandler> authenticationHandlers) {
        this.responseHandler = responseHandler;
        this.authenticationHandlers = authenticationHandlers;
    }

    public PreAuthenticationFilter(Http11ResponseHandler responseHandler, SecurityManager securityManager) {
        this.responseHandler = responseHandler;
        this.authenticationHandlers = new ArrayList<AuthenticationHandler>();
        this.authenticationHandlers.add(new SecurityManagerBasicAuthHandler(securityManager));
        this.authenticationHandlers.add(new SecurityManagerDigestAuthenticationHandler(securityManager));
    }

    public PreAuthenticationFilter(Http11ResponseHandler responseHandler, SecurityManager securityManager, NonceProvider np) {
        this.responseHandler = responseHandler;
        this.authenticationHandlers = new ArrayList<AuthenticationHandler>();
        this.authenticationHandlers.add(new SecurityManagerBasicAuthHandler(securityManager));
        this.authenticationHandlers.add(new SecurityManagerDigestAuthenticationHandler(np, securityManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(FilterChain chain, Request request, Response response) {
        log.trace("process");
        try {
            tlRequest.set(request);
            Object authTag = this.authenticate(request);
            if (authTag != null) {
                request.getAuthorization().setTag(authTag);
                chain.process(request, response);
            } else {
                this.responseHandler.respondUnauthorised(null, response, request);
            }
        }
        finally {
            tlRequest.remove();
        }
    }

    public Object authenticate(Request request) {
        for (AuthenticationHandler h : this.authenticationHandlers) {
            if (!h.supports(null, request)) continue;
            Object o = h.authenticate(null, request);
            if (o == null) {
                log.warn("authentication failed by AuthenticationHandler:" + h.getClass());
            }
            return o;
        }
        if (request.getAuthorization() == null) {
            if (log.isTraceEnabled()) {
                log.trace("No AuthenticationHandler supports this request - no authorisation given in request");
            }
        } else if (log.isWarnEnabled()) {
            log.warn("No AuthenticationHandler supports this request with scheme:" + (Object)((Object)request.getAuthorization().getScheme()));
        }
        return null;
    }

    public List<String> getChallenges(Request request) {
        ArrayList<String> challenges = new ArrayList<String>();
        for (AuthenticationHandler h : this.authenticationHandlers) {
            String ch = h.getChallenge(null, request);
            challenges.add(ch);
        }
        return challenges;
    }
}

