/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.LockingCollectionResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceHandler;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.XmlWriter;
import com.bradmcevoy.http.entity.ByteArrayEntity;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.LockedException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.PreConditionFailedException;
import com.bradmcevoy.http.webdav.LockWriterHelper;
import com.bradmcevoy.http.webdav.PropFindPropertyBuilder;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.ettrema.common.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class LockHandler
implements ResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(LockHandler.class);
    private final WebDavResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private LockWriterHelper lockWriterHelper;

    public LockHandler(WebDavResponseHandler responseHandler, HandlerHelper handlerHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        this.lockWriterHelper = new LockWriterHelper();
    }

    public LockWriterHelper getLockWriterHelper() {
        return this.lockWriterHelper;
    }

    public void setLockWriterHelper(LockWriterHelper lockWriterHelper) {
        this.lockWriterHelper = lockWriterHelper;
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.LOCK.code};
    }

    @Override
    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, BadRequestException {
        if (!this.handlerHelper.checkExpects(this.responseHandler, request, response)) {
            return;
        }
        String host = request.getHostHeader();
        String url = HttpManager.decodeUrl(request.getAbsolutePath());
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            log.debug("locking existing resource: " + r.getName());
            this.processExistingResource(manager, request, response, r);
        } else {
            log.debug("lock target doesnt exist, attempting lock null..");
            this.processNonExistingResource(manager, request, response, host, url);
        }
    }

    protected void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException {
        if (this.handlerHelper.isNotCompatible(resource, request.getMethod()) || !this.isCompatible(resource)) {
            this.responseHandler.respondMethodNotImplemented(resource, response, request);
            return;
        }
        if (!this.handlerHelper.checkAuthorisation(manager, resource, request)) {
            this.responseHandler.respondUnauthorised(resource, response, request);
            return;
        }
        this.handlerHelper.checkExpects(this.responseHandler, request, response);
        LockableResource r = (LockableResource)resource;
        LockTimeout timeout = LockTimeout.parseTimeout(request);
        String ifHeader = request.getIfHeader();
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        if (ifHeader == null || ifHeader.length() == 0) {
            this.processNewLock(manager, request, response, r, timeout);
        } else {
            this.processRefresh(manager, request, response, r, timeout, ifHeader);
        }
    }

    private void processNonExistingResource(HttpManager manager, Request request, Response response, String host, String url) throws NotAuthorizedException, BadRequestException {
        Path parentPath = Path.path(url);
        String name = parentPath.getName();
        parentPath = parentPath.getParent();
        url = parentPath.toString();
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            if (!this.handlerHelper.checkAuthorisation(manager, r, request)) {
                this.responseHandler.respondUnauthorised(r, response, request);
                return;
            }
            this.processCreateAndLock(manager, request, response, r, name);
        } else {
            log.debug("couldnt find parent to execute lock-null, returning not found");
            response.setStatus(Response.Status.SC_CONFLICT);
        }
    }

    private void processCreateAndLock(HttpManager manager, Request request, Response response, Resource parentResource, String name) throws NotAuthorizedException {
        if (parentResource instanceof LockingCollectionResource) {
            LockInfo lockInfo;
            log.debug("parent supports lock-null. doing createAndLock");
            LockingCollectionResource lockingParent = (LockingCollectionResource)parentResource;
            LockTimeout timeout = LockTimeout.parseTimeout(request);
            response.setContentTypeHeader("text/xml; charset=UTF-8");
            try {
                lockInfo = LockInfo.parseLockInfo(request);
            }
            catch (SAXException ex) {
                throw new RuntimeException("Exception reading request body", ex);
            }
            catch (IOException ex) {
                throw new RuntimeException("Exception reading request body", ex);
            }
            log.debug("Creating lock on unmapped resource: " + name);
            LockToken tok = lockingParent.createAndLock(name, timeout, lockInfo);
            if (tok == null) {
                throw new RuntimeException("createAndLock returned null, from resource of type: " + lockingParent.getClass().getCanonicalName());
            }
            response.setStatus(Response.Status.SC_CREATED);
            response.setLockTokenHeader("<opaquelocktoken:" + tok.tokenId + ">");
            this.respondWithToken(tok, request, response);
        } else {
            log.debug("parent does not support lock-null, respondong method not allowed");
            this.responseHandler.respondMethodNotImplemented(parentResource, response, request);
        }
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof LockableResource;
    }

    protected void processNewLock(HttpManager milton, Request request, Response response, LockableResource r, LockTimeout timeout) throws NotAuthorizedException {
        LockResult result;
        LockInfo lockInfo;
        try {
            lockInfo = LockInfo.parseLockInfo(request);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Exception reading request body", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception reading request body", ex);
        }
        if (this.handlerHelper.isLockedOut(request, r)) {
            this.responseHandler.respondLocked(request, response, r);
            return;
        }
        log.debug("locking: " + r.getName());
        try {
            result = r.lock(timeout, lockInfo);
        }
        catch (PreConditionFailedException ex) {
            this.responseHandler.respondPreconditionFailed(request, response, r);
            return;
        }
        catch (LockedException ex) {
            this.responseHandler.respondLocked(request, response, r);
            return;
        }
        if (result.isSuccessful()) {
            LockToken tok = result.getLockToken();
            log.debug("..locked ok: " + tok.tokenId);
            response.setLockTokenHeader("<opaquelocktoken:" + tok.tokenId + ">");
            this.respondWithToken(tok, request, response);
        } else {
            this.respondWithLockFailure(result, request, response);
        }
    }

    protected void processRefresh(HttpManager milton, Request request, Response response, LockableResource r, LockTimeout timeout, String ifHeader) throws NotAuthorizedException {
        LockResult result;
        String token = LockHandler.parseToken(ifHeader);
        log.debug("refreshing lock: " + token);
        try {
            result = r.refreshLock(token);
        }
        catch (PreConditionFailedException ex) {
            this.responseHandler.respondPreconditionFailed(request, response, r);
            return;
        }
        if (result.isSuccessful()) {
            LockToken tok = result.getLockToken();
            this.respondWithToken(tok, request, response);
        } else {
            this.respondWithLockFailure(result, request, response);
        }
    }

    protected void respondWithToken(LockToken tok, Request request, Response response) {
        response.setStatus(Response.Status.SC_OK);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)out);
        writer.writeXMLHeader();
        String d = "d";
        writer.open(d + ":prop  xmlns:" + d + "=\"DAV:\"");
        writer.newLine();
        writer.open(d + ":lockdiscovery");
        writer.newLine();
        writer.open(d + ":activelock");
        writer.newLine();
        this.lockWriterHelper.appendType(writer, tok.info.type);
        this.lockWriterHelper.appendScope(writer, tok.info.scope);
        this.lockWriterHelper.appendDepth(writer, tok.info.depth);
        this.lockWriterHelper.appendOwner(writer, tok.info.lockedByUser);
        this.lockWriterHelper.appendTimeout(writer, tok.timeout.getSeconds());
        this.lockWriterHelper.appendTokenId(writer, tok.tokenId);
        String url = PropFindPropertyBuilder.fixUrlForWindows(request.getAbsoluteUrl());
        this.lockWriterHelper.appendRoot(writer, url);
        writer.close(d + ":activelock");
        writer.close(d + ":lockdiscovery");
        writer.close(d + ":prop");
        writer.flush();
        LogUtils.debug(log, "lock response: ", out);
        response.setEntity(new ByteArrayEntity(out.toByteArray()));
    }

    static String parseToken(String ifHeader) {
        String token = ifHeader;
        int pos = token.indexOf(":");
        if (pos >= 0 && (pos = (token = token.substring(pos + 1)).indexOf(">")) >= 0) {
            token = token.substring(0, pos);
        }
        return token;
    }

    private void respondWithLockFailure(LockResult result, Request request, Response response) {
        log.info("respondWithLockFailure: " + result.getFailureReason().name());
        response.setStatus(result.getFailureReason().status);
    }
}

