/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.basex.core.Context;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTCommand;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTRun;
import org.basex.http.rest.RESTScript;
import org.basex.http.rest.RESTSession;
import org.basex.http.rest.RESTText;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.NewlineInput;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;

final class RESTPost {
    private RESTPost() {
    }

    public static RESTCmd get(RESTSession session) throws IOException {
        DBNode doc;
        HTTPConnection conn = session.conn;
        String enc = conn.req.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] input = new NewlineInput((InputStream)conn.req.getInputStream()).encoding(enc).content();
        Context ctx = conn.context;
        try {
            doc = new DBNode((IO)new IOContent(input));
        }
        catch (IOException ex) {
            throw HTTPCode.BAD_REQUEST_X.get(ex);
        }
        try {
            String value;
            Object name;
            Object qp;
            String cmd = RESTPost.value("local-name(*)", (Item)doc, ctx);
            if (cmd.equals("commands")) {
                String script = DataBuilder.stripNS((ANode)doc, (byte[])RESTText.REST_URI, (Context)ctx).serialize().toString();
                return RESTScript.get(session, script);
            }
            SerializerOptions sopts = conn.sopts();
            Throwable throwable = null;
            Throwable throwable2 = null;
            try {
                qp = new QueryProcessor("*/*:parameter", ctx).context((Value)doc);
                try {
                    for (Item param : qp.value()) {
                        name = RESTPost.value("@name", param, ctx);
                        value = RESTPost.value("@value", param, ctx);
                        if (sopts.option((String)name) != null) {
                            sopts.assign((String)name, value);
                            continue;
                        }
                        throw HTTPCode.UNKNOWN_PARAM_X.get(name);
                    }
                }
                finally {
                    if (qp != null) {
                        qp.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            throwable = null;
            throwable2 = null;
            try {
                qp = new QueryProcessor("*/*:option", ctx).context((Value)doc);
                try {
                    for (Item item : qp.value()) {
                        name = RESTPost.value("@name", item, ctx).toUpperCase(Locale.ENGLISH);
                        value = RESTPost.value("@value", item, ctx);
                        ctx.options.assign((String)name, value);
                    }
                }
                finally {
                    if (qp != null) {
                        qp.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            HashMap<String, String[]> vars = new HashMap<String, String[]>();
            throwable2 = null;
            qp = null;
            try (QueryProcessor qp2 = new QueryProcessor("*/*:variable", ctx).context((Value)doc);){
                for (Item item : qp2.value()) {
                    String name2 = RESTPost.value("@name", item, ctx);
                    String value2 = RESTPost.value("@value", item, ctx);
                    String type = RESTPost.value("@type", item, ctx);
                    vars.put(name2, new String[]{value2, type});
                }
            }
            catch (Throwable qp22) {
                if (throwable2 == null) {
                    throwable2 = qp22;
                } else if (throwable2 != qp22) {
                    throwable2.addSuppressed(qp22);
                }
                throw throwable2;
            }
            String val = null;
            qp = null;
            Object var11_22 = null;
            try (QueryProcessor qp3 = new QueryProcessor("*/*:context/(*, text()[normalize-space()])", ctx).context((Value)doc);){
                for (Item item : qp3.value()) {
                    if (val != null) {
                        throw HTTPCode.MULTIPLE_CONTEXT_X.get(new Object[0]);
                    }
                    val = DataBuilder.stripNS((ANode)((ANode)item), (byte[])RESTText.REST_URI, (Context)ctx).serialize().toString();
                }
            }
            catch (Throwable throwable5) {
                if (qp == null) {
                    qp = throwable5;
                } else if (qp != throwable5) {
                    ((Throwable)qp).addSuppressed(throwable5);
                }
                throw qp;
            }
            String text = RESTPost.value("*/*:text/text()", (Item)doc, ctx);
            if (cmd.equals("command")) {
                return RESTCommand.get(session, text);
            }
            if (cmd.equals("run")) {
                return RESTRun.get(session, text, vars, val);
            }
            if (cmd.equals("query")) {
                return RESTQuery.get(session, text, vars, val);
            }
            throw HTTPCode.BAD_REQUEST_X.get("Invalid POST command: " + cmd);
        }
        catch (QueryException ex) {
            throw HTTPCode.BAD_REQUEST_X.get(new Object[]{ex});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String value(String query, Item value, Context ctx) throws QueryException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (QueryProcessor qp = new QueryProcessor(query, ctx).context((Value)value);){
            Item item = qp.iter().next();
            return item == null ? "" : Token.string((byte[])item.string(null));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

