/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.locks;

import java.util.LinkedList;
import java.util.Queue;
import org.basex.core.locks.LockQueue;

public final class NonfairLockQueue
extends LockQueue {
    private final Queue<Long> readers = new LinkedList<Long>();
    private final Queue<Long> writers = new LinkedList<Long>();

    NonfairLockQueue(int parallel) {
        super(parallel);
    }

    @Override
    public synchronized void acquire(Long id, boolean read, boolean write) throws InterruptedException {
        if (this.jobs >= this.parallel && (read || write)) {
            Queue<Long> queue = write ? this.writers : this.readers;
            queue.add(id);
            do {
                this.wait();
            } while (this.jobs >= this.parallel || write && !this.readers.isEmpty() || !id.equals(queue.peek()));
            queue.remove(id);
        }
        ++this.jobs;
    }

    public synchronized String toString() {
        return "Jobs: " + this.jobs + ", queued readers: " + this.readers + ", queued writers: " + this.writers;
    }
}

