/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.AbstractButton;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.core.parse.CommandParser;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXHeader;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.SyntaxXML;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Token;
import org.basex.util.Util;

public final class TextView
extends View {
    private final SearchEditor search;
    private final BaseXHeader header;
    private final AbstractButton home;
    private final TextPanel text;
    private Command cachedCmd;
    private DBNodes cachedNodes;

    public TextView(ViewNotifier notifier) {
        super("text", notifier);
        this.border(5).layout(new BorderLayout(0, 5));
        this.header = new BaseXHeader(Text.RESULT);
        this.home = BaseXButton.command(GUIMenuCmd.C_HOME, this.gui);
        this.home.setEnabled(false);
        this.text = new TextPanel(this.gui, false);
        this.text.setSyntax(new SyntaxXML());
        this.search = new SearchEditor(this.gui, this.text);
        AbstractButton save = BaseXButton.get("c_save", Text.SAVE, false, this.gui);
        AbstractButton find = this.search.button(Text.FIND);
        BaseXBack buttons = new BaseXBack(false);
        buttons.layout(new TableLayout(1, 3));
        buttons.add(save);
        buttons.add(this.home);
        buttons.add(find);
        BaseXBack b = new BaseXBack(false).layout(new BorderLayout());
        b.add((Component)buttons, "West");
        b.add((Component)this.header, "East");
        this.add((Component)b, "North");
        this.add((Component)this.search, "Center");
        save.addActionListener(e -> this.save());
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
        this.refreshContext(true, true);
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        this.setText(this.gui.context.marked);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.setText(this.gui.context.current());
    }

    @Override
    public void refreshLayout() {
        this.text.setFont(GUIConstants.mfont);
    }

    @Override
    public void refreshUpdate() {
        this.refreshContext(true, true);
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWTEXT);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWTEXT, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    private void setText(DBNodes nodes) {
        if (this.visible()) {
            try {
                ArrayOutput ao = new ArrayOutput();
                ao.setLimit(this.gui.gopts.get(GUIOptions.MAXTEXT));
                if (nodes != null) {
                    nodes.serialize(Serializer.get(ao));
                }
                this.setText(ao);
                this.cachedCmd = null;
                this.cachedNodes = ao.finished() ? nodes : null;
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        } else {
            this.home.setEnabled(this.gui.context.data() != null);
        }
    }

    public void cache(ArrayOutput out, Command command, Value result) throws QueryException {
        this.cachedCmd = null;
        this.cachedNodes = null;
        int max = this.gui.gopts.get(GUIOptions.MAXRESULTS);
        boolean cacheCmd = false;
        if (result != null && result.size() >= (long)max) {
            cacheCmd = true;
        } else if (out.finished()) {
            if (result instanceof DBNodes) {
                this.cachedNodes = (DBNodes)result;
            } else {
                cacheCmd = true;
            }
        }
        if (cacheCmd) {
            this.cachedCmd = CommandParser.get(command.toString(), this.gui.context).parseSingle();
            this.cachedCmd.baseURI(command.baseURI());
        }
    }

    public void setText(ArrayOutput out) {
        byte[] buf = out.buffer();
        int size = (int)out.size();
        byte[] chop = Token.token("...");
        int cl = chop.length;
        if (out.finished() && size >= cl) {
            System.arraycopy(chop, 0, buf, size - cl, cl);
        }
        this.text.setText(buf, size);
        this.header.setText(String.valueOf(out.finished() ? Text.CHOPPED : "") + Text.RESULT);
        this.home.setEnabled(this.gui.context.data() != null);
    }

    private void save() {
        BaseXFileChooser fc = new BaseXFileChooser(this.gui, Text.SAVE_AS, this.gui.gopts.get(GUIOptions.WORKPATH)).suffix(".xml");
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null) {
            return;
        }
        this.gui.gopts.set(GUIOptions.WORKPATH, file.path());
        this.gui.cursor(GUIConstants.CURSORWAIT, true);
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (PrintOutput out = new PrintOutput(file.toString());){
                    if (this.cachedCmd != null) {
                        this.cachedCmd.execute(this.gui.context, out);
                    } else if (this.cachedNodes != null) {
                        this.cachedNodes.serialize(Serializer.get(out));
                    } else {
                        out.write(this.text.getText());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
                BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_SAVED_X, file));
                this.gui.cursor(GUIConstants.CURSORARROW, true);
            }
        }
        finally {
            this.gui.cursor(GUIConstants.CURSORARROW, true);
        }
    }
}

