/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.io.IOException;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.io.parse.json.JsonAttsConverter;
import org.basex.io.parse.json.JsonBasicConverter;
import org.basex.io.parse.json.JsonDirectConverter;
import org.basex.io.parse.json.JsonFallback;
import org.basex.io.parse.json.JsonMLConverter;
import org.basex.io.parse.json.JsonParser;
import org.basex.io.parse.json.JsonXQueryConverter;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.Item;
import org.basex.util.Token;

public abstract class JsonConverter {
    final JsonParserOptions jopts;
    JsonFallback fallback;

    JsonConverter(JsonParserOptions jopts) {
        this.jopts = jopts;
    }

    public final JsonConverter fallback(JsonFallback func) {
        this.fallback = func;
        return this;
    }

    public final Item convert(IO input) throws IOException {
        String encoding = this.jopts.get(JsonParserOptions.ENCODING);
        return this.convert(new NewlineInput(input).encoding(encoding).content(), input.path());
    }

    public final Item convert(byte[] input, String path) throws QueryIOException {
        JsonParser.parse(Token.string(input), path, this.jopts, this);
        return this.finish();
    }

    public static JsonConverter get(JsonParserOptions jopts) throws QueryIOException {
        switch (jopts.get(JsonOptions.FORMAT)) {
            case JSONML: {
                return new JsonMLConverter(jopts);
            }
            case ATTRIBUTES: {
                return new JsonAttsConverter(jopts);
            }
            case XQUERY: {
                return new JsonXQueryConverter(jopts);
            }
            case BASIC: {
                return new JsonBasicConverter(jopts);
            }
        }
        return new JsonDirectConverter(jopts);
    }

    abstract void openObject() throws QueryIOException;

    abstract void openPair(byte[] var1, boolean var2) throws QueryIOException;

    abstract void closePair(boolean var1) throws QueryIOException;

    abstract void closeObject();

    abstract void openArray() throws QueryIOException;

    abstract void openItem();

    abstract void closeItem();

    abstract void closeArray() throws QueryIOException;

    abstract void numberLit(byte[] var1) throws QueryIOException;

    abstract void stringLit(byte[] var1) throws QueryIOException;

    abstract void nullLit() throws QueryIOException;

    abstract void booleanLit(byte[] var1) throws QueryIOException;

    abstract Item finish();
}

