/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.FnError;
import org.basex.query.scope.Scope;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dummy;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.TokenList;

public final class CompileContext {
    public static final int MAX_PREEVAL = 262144;
    public final QueryContext qc;
    private final ArrayList<VarScope> scopes = new ArrayList();
    private final ArrayList<QueryFocus> focuses = new ArrayList();

    public CompileContext(QueryContext qc) {
        this.qc = qc;
    }

    public void info(String string, Object ... ext) {
        TokenList tl = new TokenList();
        Object[] objectArray = ext;
        int n = ext.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            tl.add(QueryError.chop(TokenBuilder.token(e), null));
            ++n2;
        }
        this.qc.info.compInfo(string, tl.finish());
    }

    public void pushScope(VarScope vs) {
        this.scopes.add(vs);
    }

    public VarScope removeScope() {
        return this.scopes.remove(this.scopes.size() - 1);
    }

    public void removeScope(Scope scope) {
        this.removeScope().cleanUp(scope);
    }

    public void pushFocus(Expr expr) {
        this.focuses.add(this.qc.focus);
        QueryFocus focus = new QueryFocus();
        if (expr != null) {
            focus.value = this.dummyItem(expr);
        }
        this.qc.focus = focus;
    }

    public void updateFocus(Expr expr) {
        if (expr != null) {
            this.qc.focus.value = this.dummyItem(expr);
        }
    }

    public Item dummyItem(Expr expr) {
        Value value = this.qc.focus.value;
        Data data = (value != null && expr instanceof Step ? value : expr).data();
        return new Dummy(expr.seqType().type, data);
    }

    public void removeFocus() {
        this.qc.focus = this.focuses.remove(this.focuses.size() - 1);
    }

    public boolean nestedFocus() {
        return !this.focuses.isEmpty();
    }

    public VarScope vs() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public StaticContext sc() {
        return this.vs().sc;
    }

    public Var copy(Var var, IntObjMap<Var> vm) {
        if (var == null) {
            return null;
        }
        VarScope vs = this.vs();
        Var vr = vs.add(new Var(var, this.qc, vs.sc));
        if (vm != null) {
            vm.put(var.id, vr);
        }
        return vr;
    }

    public Expr preEval(Expr expr) throws QueryException {
        return this.replaceWith(expr, expr.value(this.qc));
    }

    public Expr emptySeq(Expr result) {
        return this.replaceWith(result, null);
    }

    public Expr replaceEbv(Expr expr, Expr result) {
        return this.replaceWith(expr, result, false);
    }

    public Expr replaceWith(Expr expr, Expr result) {
        return this.replaceWith(expr, result, true);
    }

    private Expr replaceWith(Expr expr, Expr result, boolean refine) {
        Expr res;
        Expr expr2 = res = result == null ? Empty.SEQ : result;
        if (res != expr) {
            Object rt;
            Object et;
            byte[] resString;
            byte[] exprString = QueryError.chop(Token.token(expr.toString()), null);
            if (!Token.eq(exprString, resString = QueryError.chop(Token.token(res.toString()), null))) {
                TokenBuilder tb = new TokenBuilder();
                String exprDesc = expr.description();
                String resDesc = res.description();
                tb.add(res instanceof ParseExpr ? "rewrite" : "pre-evaluate").add(32).add(exprDesc);
                if (!exprDesc.equals(resDesc)) {
                    tb.add(" to ").add(resDesc);
                }
                this.info(tb.add(": ").add(exprString).add(" -> ").add(resString).toString(), new Object[0]);
            }
            if (res instanceof ParseExpr) {
                if (refine) {
                    SeqType st;
                    ParseExpr re = (ParseExpr)res;
                    et = expr.seqType();
                    if (!((SeqType)et).eq((SeqType)(rt = re.seqType())) && ((SeqType)et).instanceOf((SeqType)rt) && (st = ((SeqType)et).intersect((SeqType)rt)) != null) {
                        re.exprType.assign(st);
                    }
                }
            } else if (res != Empty.SEQ && refine) {
                if (res instanceof Seq) {
                    Type type;
                    Seq seq = (Seq)res;
                    et = expr.seqType().type;
                    rt = seq.type;
                    if (!et.eq((Type)rt) && et.instanceOf((Type)rt) && (type = et.intersect((Type)rt)) != null) {
                        seq.type = type;
                        seq.homo = false;
                    }
                } else if (res instanceof FItem) {
                    Type type;
                    FItem fitem = (FItem)res;
                    et = expr.seqType();
                    if (!((SeqType)et).eq((SeqType)(rt = res.seqType())) && ((SeqType)et).instanceOf((SeqType)rt) && (type = ((SeqType)et).type.intersect(((SeqType)rt).type)) != null) {
                        fitem.type = type;
                    }
                }
            }
        }
        return res;
    }

    public StandardFunc error(QueryException qe, Expr expr) {
        return FnError.get(qe, expr.seqType(), this.sc());
    }

    public Expr function(Function func, InputInfo info, Expr ... exprs) throws QueryException {
        return func.get(this.sc(), info, exprs).optimize(this);
    }
}

