/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class Condition
extends Single {
    private final boolean start;
    private final Var item;
    private final Var pos;
    private final Var prev;
    private final Var next;

    public Condition(boolean start, Var item, Var pos, Var prev, Var next, Expr cond, InputInfo info) {
        super(info, cond, SeqType.ITEM_ZM);
        this.start = start;
        this.item = item;
        this.pos = pos;
        this.prev = prev;
        this.next = next;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.expr = this.expr.compile(cc);
        return this.optimize(cc);
    }

    @Override
    public Condition optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.optimizeEbv(cc);
        return this;
    }

    @Override
    public Condition inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        return (Condition)super.inline(var, ex, cc);
    }

    @Override
    public Condition copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Condition(this.start, cc.copy(this.item, vm), cc.copy(this.pos, vm), cc.copy(this.prev, vm), cc.copy(this.next, vm), this.expr.copy(cc, vm), this.info));
    }

    int nVars() {
        int i = 0;
        if (this.item != null) {
            ++i;
        }
        if (this.pos != null) {
            ++i;
        }
        if (this.prev != null) {
            ++i;
        }
        if (this.next != null) {
            ++i;
        }
        return i;
    }

    boolean usesNext() {
        return this.next != null;
    }

    void writeVars(Var[] arr, int p) {
        int i = p;
        if (this.item != null) {
            arr[i++] = this.item;
        }
        if (this.pos != null) {
            arr[i++] = this.pos;
        }
        if (this.prev != null) {
            arr[i++] = this.prev;
        }
        if (this.next != null) {
            arr[i] = this.next;
        }
    }

    boolean matches(QueryContext qc, Item it, long ps, Item pr, Item nx) throws QueryException {
        this.bind(qc, it, ps, pr, nx);
        return this.expr.ebv(qc, this.info).bool(this.info);
    }

    void bind(QueryContext qc, Item it, long ps, Item pr, Item nx) throws QueryException {
        if (this.item != null) {
            qc.set(this.item, it == null ? Empty.SEQ : it);
        }
        if (this.pos != null) {
            qc.set(this.pos, Int.get(ps));
        }
        if (this.prev != null) {
            qc.set(this.prev, pr == null ? Empty.SEQ : pr);
        }
        if (this.next != null) {
            qc.set(this.next, nx == null ? Empty.SEQ : nx);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return !(this.item != null && !visitor.declared(this.item) || this.pos != null && !visitor.declared(this.pos) || this.prev != null && !visitor.declared(this.prev) || this.next != null && !visitor.declared(this.next) || !this.expr.accept(visitor));
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition c = (Condition)obj;
        return Objects.equals(this.item, c.item) && Objects.equals(this.pos, c.pos) && Objects.equals(this.prev, c.prev) && Objects.equals(this.next, c.next) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = new FElem(this.start ? "start" : "end");
        if (this.item != null) {
            elem.add(Condition.planAttr("var", Token.token(this.item.toString())));
        }
        if (this.pos != null) {
            elem.add(Condition.planAttr(Token.token("at"), Token.token(this.pos.toString())));
        }
        if (this.prev != null) {
            elem.add(Condition.planAttr(Token.token("previous"), Token.token(this.prev.toString())));
        }
        if (this.next != null) {
            elem.add(Condition.planAttr(Token.token("next"), Token.token(this.next.toString())));
        }
        if (this.item != null) {
            this.item.plan(elem);
        }
        if (this.pos != null) {
            this.pos.plan(elem);
        }
        if (this.prev != null) {
            this.prev.plan(elem);
        }
        if (this.next != null) {
            this.next.plan(elem);
        }
        this.expr.plan(elem);
        plan.add(elem);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.start ? "start" : "end");
        if (this.item != null) {
            sb.append(' ').append(this.item);
        }
        if (this.pos != null) {
            sb.append(' ').append("at").append(' ').append(this.pos);
        }
        if (this.prev != null) {
            sb.append(' ').append("previous").append(' ').append(this.prev);
        }
        if (this.next != null) {
            sb.append(' ').append("next").append(' ').append(this.next);
        }
        return sb.append(' ').append("when").append(' ').append(this.expr).toString();
    }
}

