/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.nio.ByteOrder;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.bin.BinFn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;

public final class BinPackInteger
extends BinFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        long value = this.toLong(this.exprs[0], qc);
        long size = this.toLong(this.exprs[1], qc);
        ByteOrder bo = this.order(2, qc);
        if (size < 0L) {
            throw QueryError.BIN_NS_X.get(this.info, size);
        }
        byte[] tmp = new byte[(int)size];
        int tl = tmp.length;
        if (bo == ByteOrder.BIG_ENDIAN) {
            int t = tl - 1;
            while (t >= 0) {
                tmp[t] = (byte)value;
                value >>= 8;
                --t;
            }
        } else {
            int t = 0;
            while (t < tl) {
                tmp[t] = (byte)value;
                value >>= 8;
                ++t;
            }
        }
        return B64.get(tmp);
    }
}

