/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.basex.io.IOFile;
import org.basex.io.in.NewlineInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileRead;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

public final class FileReadTextLines
extends FileRead {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        long length;
        this.checkCreate(qc);
        Path path = this.toPath(0, qc);
        String encoding = this.toEncoding(1, QueryError.FILE_UNKNOWN_ENCODING_X, qc);
        boolean validate = this.exprs.length < 3 || !this.toBoolean(this.exprs[2], qc);
        long start = this.exprs.length < 4 ? 1L : this.toLong(this.exprs[3], qc);
        long l = length = this.exprs.length < 5 ? Long.MAX_VALUE : this.toLong(this.exprs[4], qc);
        if (!Files.exists(path, new LinkOption[0])) {
            throw QueryError.FILE_NOT_FOUND_X.get(this.info, path.toAbsolutePath());
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw QueryError.FILE_IS_DIR_X.get(this.info, path.toAbsolutePath());
        }
        try {
            Throwable throwable = null;
            Object var10_10 = null;
            try (NewlineInput ni = new NewlineInput(new IOFile(path.toFile()));){
                ni.encoding(encoding).validate(validate);
                long end = start + length < 0L ? Long.MAX_VALUE : start + length;
                TokenBuilder tb = new TokenBuilder();
                TokenList tl = new TokenList();
                long c = 1L;
                while (c < end) {
                    if (!ni.readLine(tb)) break;
                    if (c >= start) {
                        tl.add(tb.toArray());
                    }
                    ++c;
                }
                return StrSeq.get(tl);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw QueryError.FILE_IO_ERROR_X.get(this.info, ex);
        }
    }

    public static Expr rewrite(StandardFunc func, long start, long length, CompileContext cc, InputInfo info) throws QueryException {
        Expr[] args;
        int al;
        Expr arg = func.exprs[0];
        if (arg instanceof FileReadTextLines && (al = (args = ((Arr)arg).exprs).length) < 4) {
            ExprList list = (ExprList)new ExprList().add(args);
            if (al < 2) {
                list.add(Str.get("UTF-8"));
            }
            if (al < 3) {
                list.add(Bln.FALSE);
            }
            ((ExprList)((Object)list.add(Int.get(start)))).add(Int.get(length));
            return cc.function(Function._FILE_READ_TEXT_LINES, info, (Expr[])list.finish());
        }
        return func;
    }
}

