/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import java.lang.reflect.Method;
import java.util.Comparator;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.collation.UCAOptions;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Token;

final class UCACollation
extends Collation {
    private static final Class<?> CEI = Reflect.find("com.ibm.icu.text.CollationElementIterator");
    private static final Method RBC_GCEI = Reflect.method(UCAOptions.RBC, "getCollationElementIterator", String.class);
    private static final Method CEI_GET_OFFSET = Reflect.method(CEI, "getOffset", new Class[0]);
    private static final Method CEI_SET_OFFSET = Reflect.method(CEI, "setOffset", Integer.TYPE);
    private static final Method CEI_NEXT = Reflect.method(CEI, "next", new Class[0]);
    private final Comparator<Object> collator;

    UCACollation(Comparator<Object> collator) {
        this.collator = collator;
    }

    @Override
    public int compare(byte[] string, byte[] compare) {
        return this.collator.compare(Token.string(string), Token.string(compare));
    }

    @Override
    protected int indexOf(String string, String contains, Collation.Mode mode, InputInfo info) {
        Object iterS = Reflect.invoke(RBC_GCEI, this.collator, string);
        Object iterC = Reflect.invoke(RBC_GCEI, this.collator, contains);
        int elemC = UCACollation.next(iterC);
        if (elemC == -1) {
            return 0;
        }
        int offC = (Integer)Reflect.invoke(CEI_GET_OFFSET, iterC, new Object[0]);
        while (true) {
            int elemS;
            if ((elemS = UCACollation.next(iterS)) != elemC) {
                if (elemS != -1 && mode != Collation.Mode.STARTS_WITH) continue;
                return -1;
            }
            int offS = (Integer)Reflect.invoke(CEI_GET_OFFSET, iterS, new Object[0]);
            if (UCACollation.startsWith(iterS, iterC)) {
                if (mode == Collation.Mode.INDEX_AFTER) {
                    return (Integer)Reflect.invoke(CEI_GET_OFFSET, iterS, new Object[0]);
                }
                if (mode == Collation.Mode.ENDS_WITH) {
                    if (UCACollation.next(iterS) == -1) {
                        return offS - 1;
                    }
                } else {
                    return offS - 1;
                }
            }
            Reflect.invoke(CEI_SET_OFFSET, iterC, offS);
            Reflect.invoke(CEI_SET_OFFSET, iterC, offC);
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof UCACollation && this.collator.equals(((UCACollation)obj).collator);
    }

    private static boolean startsWith(Object string, Object sub) {
        int s;
        do {
            if ((s = UCACollation.next(sub)) != -1) continue;
            return true;
        } while (s == UCACollation.next(string));
        return false;
    }

    private static int next(Object it) {
        int c;
        while ((c = ((Integer)Reflect.invoke(CEI_NEXT, it, new Object[0])).intValue()) == 0) {
        }
        return c;
    }
}

