/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.io.Reader;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Optimize;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOStream;
import org.basex.util.Util;

public abstract class ACreate
extends Command {
    private boolean newData;
    protected boolean lock = true;

    ACreate(String ... args) {
        this(Perm.CREATE, false, args);
        this.newData = true;
    }

    ACreate(Perm perm, boolean openDB, String ... args) {
        super(perm, openDB, args);
    }

    final IO sourceToIO(String name) throws IOException {
        IO io = null;
        if (this.args[1] != null && !this.args[1].isEmpty()) {
            io = IO.get(this.args[1]);
        } else if (this.in != null) {
            if (this.in.getCharacterStream() != null) {
                StringBuilder sb = new StringBuilder();
                Throwable throwable = null;
                Object var5_6 = null;
                try (Reader r = this.in.getCharacterStream();){
                    int c;
                    while ((c = r.read()) != -1) {
                        sb.append((char)c);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                io = new IOContent(sb.toString());
            } else if (this.in.getByteStream() != null) {
                io = new IOStream(this.in.getByteStream());
            } else if (this.in.getSystemId() != null) {
                io = IO.get(this.in.getSystemId());
            }
        }
        if (io instanceof IOContent || io instanceof IOStream) {
            if (name.endsWith("/")) {
                throw new BaseXException(Text.NAME_INVALID_X, name);
            }
            io.name(name.isEmpty() ? "" : String.valueOf(name) + '.' + (Object)((Object)this.options.get(MainOptions.PARSER)));
        }
        return io;
    }

    final boolean update(Data data, Code update) {
        IOException exc = null;
        try {
            if (this.lock) {
                data.startUpdate(this.options);
            }
            boolean bl = update.run();
            return bl;
        }
        catch (IOException ex) {
            exc = ex;
        }
        finally {
            try {
                Optimize.finish(data);
                if (this.lock) {
                    data.finishUpdate(this.options);
                }
            }
            catch (IOException ex) {
                if (exc == null) {
                    exc = ex;
                }
                Util.debug(ex);
            }
        }
        return this.error(Util.message(exc), new Object[0]);
    }

    @Override
    public boolean newData(Context ctx) {
        if (this.newData) {
            Close.close(ctx);
        }
        return this.newData;
    }

    @Override
    public void addLocks() {
        this.jc().locks.writes.add("%CONTEXT");
    }

    @Override
    public final boolean supportsProg() {
        return true;
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    static abstract class Code {
        Code() {
        }

        abstract boolean run() throws IOException;
    }
}

