/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.ComponentOrientation;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;
import org.basex.util.Prop;

public final class GUIMenu
extends JMenuBar {
    private final JMenuItem[] items;
    private final GUI gui;

    GUIMenu(GUI gui) {
        this.gui = gui;
        if (Prop.langright) {
            this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        int c = 0;
        GUICommand[][] gUICommandArray = GUIConstants.MENUITEMS;
        int n = GUIConstants.MENUITEMS.length;
        int n2 = 0;
        while (n2 < n) {
            GUICommand[] cmds = gUICommandArray[n2];
            c += cmds.length;
            ++n2;
        }
        this.items = new JMenuItem[c];
        c = 0;
        StringBuilder gmnem = new StringBuilder();
        int bl = GUIConstants.MENUBAR.length;
        int b = 0;
        while (b < bl) {
            JMenu menu = new JMenu(GUIConstants.MENUBAR[b]);
            BaseXLayout.setMnemonic(menu, gmnem);
            StringBuilder mnemCache = new StringBuilder();
            GUICommand[] gUICommandArray2 = GUIConstants.MENUITEMS[b];
            int n3 = gUICommandArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                GUICommand cmd = gUICommandArray2[n4];
                if (cmd == GUICommand.SEPARATOR) {
                    menu.addSeparator();
                } else if (cmd != null) {
                    JMenuItem item = GUIMenu.newItem(cmd, gui, mnemCache);
                    item.setAccelerator(BaseXLayout.keyStroke(cmd));
                    this.items[c++] = item;
                    if (Prop.langright) {
                        item.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    }
                    menu.add(item);
                }
                ++n4;
            }
            this.add(menu);
            ++b;
        }
    }

    public static JMenuItem newItem(GUICommand cmd, GUI gui, StringBuilder mnem) {
        String desc = cmd.label();
        JMenuItem item = cmd.toggle() ? new JCheckBoxMenuItem(desc) : new JMenuItem(desc);
        item.addActionListener(e -> cmd.execute(gui));
        BaseXLayout.setMnemonic(item, mnem);
        return item;
    }

    void refresh() {
        int c = 0;
        GUICommand[][] gUICommandArray = GUIConstants.MENUITEMS;
        int n = GUIConstants.MENUITEMS.length;
        int n2 = 0;
        while (n2 < n) {
            GUICommand[] cmds;
            GUICommand[] gUICommandArray2 = cmds = gUICommandArray[n2];
            int n3 = cmds.length;
            int n4 = 0;
            while (n4 < n3) {
                GUICommand cmd = gUICommandArray2[n4];
                if (cmd != GUICommand.SEPARATOR && cmd != null) {
                    this.items[c].setEnabled(cmd.enabled(this.gui));
                    this.items[c++].setSelected(cmd.selected(this.gui));
                }
                ++n4;
            }
            ++n2;
        }
    }
}

