/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.util.ArrayList;
import java.util.Iterator;
import org.basex.data.Data;
import org.basex.index.IndexNames;
import org.basex.index.IndexType;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class ValueCache
implements Iterable<byte[]> {
    private final TokenSet keys = new TokenSet();
    private final ArrayList<IntList> ids = new ArrayList();
    private final ArrayList<IntList> pos;

    public ValueCache(int pre, IndexType type, Data data) {
        this(new IntList(1).add(pre), type, data);
    }

    public ValueCache(int pre, int size, IndexType type, Data data) {
        this(ValueCache.pres(pre, size), type, data);
    }

    public ValueCache(IntList pres, IndexType type, Data data) {
        this.pos = type == IndexType.TOKEN ? new ArrayList() : null;
        IndexNames in = new IndexNames(type, data);
        boolean text = type == IndexType.TEXT;
        int pl = pres.size();
        int kind = text ? 2 : 3;
        int p = 0;
        while (p < pl) {
            int pre = pres.get(p);
            if (data.kind(pre) == kind && in.contains(pre, text)) {
                if (type == IndexType.TOKEN) {
                    int ps = 0;
                    byte[][] byArray = Token.distinctTokens(data.text(pre, text));
                    int n = byArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte[] token = byArray[n2];
                        this.addId(token, pre, ps++, data);
                        ++n2;
                    }
                } else if (data.textLen(pre, text) <= data.meta.maxlen) {
                    this.addId(data.text(pre, text), pre, 0, data);
                }
            }
            ++p;
        }
    }

    private static IntList pres(int pre, int size) {
        IntList pres = new IntList(size);
        int last = pre + size;
        int curr = pre;
        while (curr < last) {
            pres.add(curr);
            ++curr;
        }
        return pres;
    }

    private void addId(byte[] text, int pre, int ps, Data data) {
        IntList list;
        boolean exists;
        int i = this.keys.put(text) - 1;
        boolean bl = exists = i < this.ids.size();
        if (exists) {
            list = this.ids.get(i);
        } else {
            list = new IntList(1);
            this.ids.add(list);
        }
        list.add(data.id(pre));
        if (this.pos != null) {
            if (exists) {
                list = this.pos.get(i);
            } else {
                list = new IntList(1);
                this.pos.add(list);
            }
            list.add(ps);
        }
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new TokenList(this.keys).sort().iterator();
    }

    IntList ids(byte[] key) {
        return this.ids.get(this.keys.id(key) - 1);
    }

    IntList pos(byte[] key) {
        return this.pos != null ? this.pos.get(this.keys.id(key) - 1) : null;
    }
}

