/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.path.NameTest;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Catch
extends Single {
    public static final QNm[] NAMES = new QNm[]{Catch.create(QueryText.E_CODE), Catch.create(QueryText.E_DESCRIPTION), Catch.create(QueryText.E_VALUE), Catch.create(QueryText.E_MODULE), Catch.create(QueryText.E_LINE_NUMBER), Catch.create(QueryText.E_COLUM_NUMBER), Catch.create(QueryText.E_ADDITIONAL)};
    public static final SeqType[] TYPES = new SeqType[]{SeqType.QNM_O, SeqType.STR_ZO, SeqType.ITEM_ZM, SeqType.STR_ZO, SeqType.ITR_ZO, SeqType.ITR_ZO, SeqType.ITEM_ZM};
    private final Var[] vars;
    private final NameTest[] codes;

    public Catch(InputInfo info, NameTest[] codes, Var[] vars) {
        super(info, null, SeqType.ITEM_ZM);
        this.vars = vars;
        this.codes = codes;
    }

    @Override
    public Catch compile(CompileContext cc) {
        try {
            this.expr = this.expr.compile(cc);
        }
        catch (QueryException qe) {
            this.expr = cc.error(qe, this.expr);
        }
        return this.optimize(cc);
    }

    @Override
    public Catch optimize(CompileContext cc) {
        return (Catch)this.adoptType(this.expr);
    }

    Value value(QueryContext qc, QueryException qe) throws QueryException {
        int i = 0;
        Value[] valueArray = Catch.values(qe);
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            qc.set(this.vars[i++], value);
            ++n2;
        }
        Util.debug(qe);
        return this.expr.value(qc);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        Var[] vrs = new Var[NAMES.length];
        int vl = vrs.length;
        int v = 0;
        while (v < vl) {
            vrs[v] = cc.vs().addNew(NAMES[v], TYPES[v], false, cc.qc, this.info);
            ++v;
        }
        Catch ctch = new Catch(this.info, (NameTest[])this.codes.clone(), vrs);
        int val = this.vars.length;
        int v2 = 0;
        while (v2 < val) {
            vm.put(this.vars[v2].id, ctch.vars[v2]);
            ++v2;
        }
        ctch.expr = this.expr.copy(cc, vm);
        return ctch;
    }

    @Override
    public Catch inline(Var var, Expr ex, CompileContext cc) {
        Expr sub;
        block3: {
            sub = this.expr.inline(var, ex, cc);
            if (sub != null) break block3;
            return null;
        }
        try {
            this.expr = sub;
        }
        catch (QueryException qe) {
            this.expr = cc.error(qe, this.expr);
        }
        return this;
    }

    Expr asExpr(QueryException qe, CompileContext cc) throws QueryException {
        if (this.expr instanceof Value) {
            return this.expr;
        }
        int v = 0;
        Expr ex = this.expr;
        Value[] valueArray = Catch.values(qe);
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expr ex2;
            Value value = valueArray[n2];
            if ((ex2 = ex.inline(this.vars[v++], value, cc)) != null) {
                ex = ex2;
            }
            if (ex instanceof Value) break;
            ++n2;
        }
        return ex;
    }

    public static Value[] values(QueryException qe) {
        byte[] io = qe.file() == null ? Token.EMPTY : Token.token(qe.file());
        Value value = qe.value();
        return new Value[]{qe.qname(), Str.get(qe.getLocalizedMessage()), value == null ? Empty.SEQ : value, Str.get(io), Int.get(qe.line()), Int.get(qe.column()), Str.get(qe.getMessage().replaceAll("\r\n?", "\n"))};
    }

    boolean matches(QueryException qe) {
        QNm code = qe.qname();
        NameTest[] nameTestArray = this.codes;
        int n = this.codes.length;
        int n2 = 0;
        while (n2 < n) {
            NameTest c = nameTestArray[n2];
            if (c.eq(code)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static QNm create(byte[] n) {
        return new QNm(Token.concat(QueryText.ERR_PREFIX, Token.COLON, n), QueryText.ERROR_URI);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        Var[] varArray = this.vars;
        int n = this.vars.length;
        int n2 = 0;
        while (n2 < n) {
            Var var = varArray[n2];
            if (!visitor.declared(var)) {
                return false;
            }
            ++n2;
        }
        return Catch.visitAll(visitor, this.expr);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Catch)) {
            return false;
        }
        Catch c = (Catch)obj;
        return Array.equals(this.vars, c.vars) && Array.equals(this.codes, c.codes) && super.equals(obj);
    }

    @Override
    public String toString() {
        return "catch * { " + this.expr + " }";
    }
}

