/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.client;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.api.client.ClientSession;
import org.basex.core.BaseXException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.func.client.ClientFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;

public final class ClientQuery
extends ClientFn {
    private static final Pattern QUERYPAT = Pattern.compile("\\[(.*?)] (.*)", 8);

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        ClientSession cs = this.session(qc, false);
        String query = Token.string(this.toToken(this.exprs[1], qc));
        ValueBuilder vb = new ValueBuilder(qc);
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (org.basex.api.client.ClientQuery cq = cs.query(query);){
                for (Map.Entry<String, Value> binding : this.toBindings(2, qc).entrySet()) {
                    String key = binding.getKey();
                    Value value = binding.getValue();
                    if (key.isEmpty()) {
                        cq.context(value);
                        continue;
                    }
                    cq.bind(key, value);
                }
                cq.cache(true);
                while (cq.more()) {
                    String result = cq.next();
                    Type type = cq.type();
                    if (type instanceof FuncType) {
                        throw QueryError.CLIENT_FITEM_X.get(this.info, result);
                    }
                    vb.add(cq.type().castString(result, qc, this.sc, this.info));
                }
                return vb.value();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        catch (BaseXException ex) {
            Matcher m = QUERYPAT.matcher(ex.getMessage());
            if (m.find()) {
                String msg;
                String name = m.group(1);
                QueryException exc = QueryError.get(name, msg = m.group(2), this.info);
                throw exc == null ? new QueryException(this.info, new QNm(name), msg, new Object[0]) : exc;
            }
            throw QueryError.CLIENT_QUERY_X.get(this.info, ex);
        }
        catch (IOException ex) {
            throw QueryError.CLIENT_ERROR_X.get(this.info, ex);
        }
    }
}

