/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import java.io.IOException;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryProcessor;
import org.basex.query.ann.Ann;
import org.basex.query.scope.Module;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public abstract class Inspect {
    public static final byte[][] DOC_TAGS = Token.tokens("description", "author", "version", "param", "return", "error", "deprecated", "see", "since");
    public static final byte[] DOC_DESCRIPTION = Token.token("description");
    public static final byte[] DOC_PARAM = Token.token("param");
    public static final byte[] DOC_RETURN = Token.token("return");
    final QueryContext qc;
    final InputInfo info;
    Module module;

    Inspect(QueryContext qc, InputInfo info) {
        this.qc = qc;
        this.info = info;
    }

    public abstract FElem parse(IO var1) throws QueryException;

    final QueryParser parseQuery(IO io) throws QueryException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (QueryContext qctx = new QueryContext(this.qc.context);){
                String input = Token.string(io.read());
                QueryParser qp = new QueryParser(input, io.path(), qctx, null);
                this.module = QueryProcessor.isLibrary(input) ? qp.parseLibrary(true) : qp.parseMain();
                return qp;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | QueryException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    final void comment(TokenObjMap<TokenList> tags, FElem parent) {
        for (byte[] tag : tags) {
            for (byte[] name : tags.get(tag)) {
                Inspect.add(name, this.elem(tag, parent));
            }
        }
    }

    final void annotation(AnnList anns, FElem parent, boolean uri) throws QueryException {
        for (Ann ann : anns) {
            FElem annotation = this.elem("annotation", parent);
            QNm name = ann.name();
            annotation.add("name", name.string());
            if (uri) {
                annotation.add("uri", name.uri());
            }
            Item[] itemArray = ann.args();
            int n = itemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                this.elem("literal", annotation).add("type", item.type.toString()).add(item.string(null));
                ++n2;
            }
        }
    }

    protected abstract FElem elem(byte[] var1, FElem var2);

    protected abstract FElem elem(String var1, FElem var2);

    public static void add(byte[] value, FElem elem) {
        try {
            XMLParser parser = new XMLParser(new IOContent(value), MainOptions.get(), true);
            for (ANode node : new DBNode(parser).children()) {
                elem.add(node.finish());
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            elem.add(value);
        }
    }

    public static byte[] doc(TokenObjMap<TokenList> doc, byte[] name) {
        TokenList params;
        TokenList tokenList = params = doc != null ? doc.get(DOC_PARAM) : null;
        if (params != null) {
            block0: for (byte[] param : params) {
                int s;
                int vl = param.length;
                int v = s = Token.startsWith(param, 36) ? 1 : 0;
                while (v < vl) {
                    if (Token.ws(param[v])) {
                        if (!Token.eq(Token.substring(param, s, v), name)) continue block0;
                        return Token.trim(Token.substring(param, v + 1, vl));
                    }
                    ++v;
                }
            }
        }
        return null;
    }
}

