/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.parse;

import java.util.ArrayList;
import java.util.HashMap;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.util.parse.VarContext;
import org.basex.query.value.item.QNm;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class LocalVars {
    private final ArrayList<VarContext> vars = new ArrayList();
    private final QueryParser qp;

    public LocalVars(QueryParser qp) {
        this.qp = qp;
    }

    public Var add(Var var) {
        if (var != null) {
            this.vars.get(this.vars.size() - 1).add(var);
        }
        return var;
    }

    public VarRef resolveLocal(QNm name, InputInfo ii) {
        int l = this.vars.size();
        Var var = null;
        while (--l >= 0) {
            var = this.vars.get((int)l).stack.get(name);
            if (var != null) break;
        }
        if (var == null) {
            return null;
        }
        int ls = this.vars.size();
        while (++l < ls) {
            VarContext vctx = this.vars.get(l);
            Var local = new Var(var.name, var.seqType(), false, this.qp.qc, this.qp.sc, ii);
            vctx.add(local);
            vctx.bindings.put(local, new VarRef(ii, var));
            var = local;
        }
        return new VarRef(ii, var);
    }

    public ParseExpr resolve(QNm name, InputInfo ii) throws QueryException {
        VarRef local = this.resolveLocal(name, ii);
        if (local != null) {
            return local;
        }
        byte[] uri = name.uri();
        if (this.qp.module == null || Token.eq(this.qp.module.uri(), uri) || this.qp.modules.contains(uri)) {
            return this.qp.qc.vars.newRef(name, this.qp.sc, ii);
        }
        throw this.qp.error(QueryError.VARUNDEF_X, ii, String.valueOf('$') + Token.string(name.string()));
    }

    public void pushContext(HashMap<Var, Expr> global) {
        this.vars.add(new VarContext(global, this.qp.sc));
    }

    public VarScope popContext() {
        return this.vars.remove((int)(this.vars.size() - 1)).vs;
    }

    public int openScope() {
        return this.vars.get((int)(this.vars.size() - 1)).stack.size();
    }

    public void closeScope(int marker) {
        this.vars.get((int)(this.vars.size() - 1)).stack.size(marker);
    }
}

