/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.data.DataText;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public abstract class Item
extends Value {
    public static final int UNDEF = Integer.MIN_VALUE;
    protected Double score;

    protected Item(Type type) {
        super(type);
    }

    @Override
    public final BasicIter<Item> iter() {
        return new BasicIter<Item>(1L){

            @Override
            public Item get(long i) {
                return Item.this;
            }

            @Override
            public Value value() {
                return Item.this;
            }

            @Override
            public Value value(QueryContext qc) {
                return this.value();
            }
        };
    }

    @Override
    public final Item item(QueryContext qc, InputInfo info) {
        return this;
    }

    @Override
    public final Item itemAt(long pos) {
        return this;
    }

    @Override
    public final Item reverse(QueryContext qc) {
        return this;
    }

    @Override
    public final Item ebv(QueryContext qc, InputInfo info) {
        return this;
    }

    @Override
    public Item test(QueryContext qc, InputInfo info) throws QueryException {
        return this.bool(info) ? this : null;
    }

    public abstract byte[] string(InputInfo var1) throws QueryException;

    public boolean bool(InputInfo info) throws QueryException {
        throw QueryError.EBV_X_X.get(info, this.type, this);
    }

    public BigDecimal dec(InputInfo info) throws QueryException {
        return Dec.parse(this, info);
    }

    public long itr(InputInfo info) throws QueryException {
        return Int.parse(this, info);
    }

    public float flt(InputInfo info) throws QueryException {
        return Flt.parse(this, info);
    }

    public double dbl(InputInfo info) throws QueryException {
        return Dbl.parse(this, info);
    }

    public boolean instanceOf(Type tp) {
        return this.type.instanceOf(tp);
    }

    public final boolean comparable(Item item) {
        Type type1 = this.type;
        Type type2 = item.type;
        return type1 == type2 || type1.isStringOrUntyped() && type2.isStringOrUntyped() || this instanceof ANum && item instanceof ANum || this instanceof Dur && item instanceof Dur;
    }

    public abstract boolean eq(Item var1, Collation var2, StaticContext var3, InputInfo var4) throws QueryException;

    public final boolean equiv(Item item, Collation coll, InputInfo info) throws QueryException {
        return (this == Dbl.NAN || this == Flt.NAN) && (item == Dbl.NAN || item == Flt.NAN) || this.comparable(item) && this.eq(item, coll, null, info);
    }

    public boolean sameKey(Item item, InputInfo info) throws QueryException {
        return this.comparable(item) && this.eq(item, null, null, info);
    }

    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        throw QueryError.diffError(this, item, info);
    }

    public BufferInput input(InputInfo info) throws QueryException {
        return new ArrayInput(this.string(info));
    }

    @Override
    public final Value subSequence(long start, long length, QueryContext qc) {
        return length == 1L ? this : Empty.SEQ;
    }

    @Override
    public void materialize(InputInfo info) throws QueryException {
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo info) throws QueryException {
        return this;
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo info) throws QueryException {
        return this;
    }

    @Override
    public long atomSize() {
        return 1L;
    }

    @Override
    public final SeqType seqType() {
        return this.type.seqType();
    }

    @Override
    public final long size() {
        return 1L;
    }

    @Override
    public final boolean iterable() {
        return true;
    }

    public double score() {
        Double s = this.score;
        return s == null ? 0.0 : s;
    }

    public final void score(double s) {
        if (s != 0.0) {
            this.score = s;
        }
    }

    @Override
    public int hash(InputInfo info) throws QueryException {
        return Token.hash(this.string(info));
    }

    @Override
    public final boolean homogeneous() {
        return true;
    }

    public byte[] xdmInfo() {
        return new byte[]{this.typeId().asByte()};
    }

    public Type.ID typeId() {
        return this.type.id();
    }

    @Override
    public void plan(FElem plan) {
        try {
            Item.addPlan(plan, this.planElem("type", this.type), new Object[]{Item.string(this.string(null), false, true)});
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public String description() {
        return this.type.toString();
    }

    public static String toString(byte[] value) {
        return Item.toString(value, true, true);
    }

    public static String toString(byte[] value, boolean quotes, boolean limit) {
        return Token.string(Item.string(value, quotes, limit));
    }

    public static byte[] string(byte[] value, boolean quotes, boolean limit) {
        TokenBuilder tb = new TokenBuilder();
        if (quotes) {
            tb.add(34);
        }
        byte[] byArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            byte v = byArray[n2];
            if (limit && tb.size() > 255) {
                tb.add("...");
                break;
            }
            if (v == 38) {
                tb.add(DataText.E_AMP);
            } else if (v == 13) {
                tb.add(DataText.E_CR);
            } else if (v == 10) {
                tb.add(DataText.E_NL);
            } else if (v == 34 && quotes) {
                tb.add(34).add(34);
            } else {
                tb.addByte(v);
            }
            ++n2;
        }
        if (quotes) {
            tb.add(34);
        }
        return tb.finish();
    }
}

