/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class YMDur
extends Dur {
    public YMDur(Dur value) {
        super(AtomType.YMD);
        this.mon = value.mon;
        this.sec = BigDecimal.ZERO;
    }

    public YMDur(YMDur value, YMDur dur, boolean plus, InputInfo info) throws QueryException {
        this(value);
        double d = (double)this.mon + (double)(plus ? dur.mon : -dur.mon);
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw QueryError.MONTHRANGE_X.get(info, d);
        }
        this.mon += plus ? dur.mon : -dur.mon;
    }

    public YMDur(Dur value, double factor, boolean mult, InputInfo info) throws QueryException {
        this(value);
        double d;
        if (Double.isNaN(factor)) {
            throw QueryError.DATECALC_X_X.get(info, this.description(), factor);
        }
        if (mult ? Double.isInfinite(factor) : factor == 0.0) {
            throw QueryError.DATEZERO_X_X.get(info, this.type, factor);
        }
        double d2 = d = mult ? (double)this.mon * factor : (double)this.mon / factor;
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw QueryError.MONTHRANGE_X.get(info, d);
        }
        this.mon = StrictMath.round(d);
    }

    public YMDur(byte[] value, InputInfo info) throws QueryException {
        super(AtomType.YMD);
        String val = Token.string(value).trim();
        Matcher mt = YMD.matcher(val);
        if (!mt.matches() || val.endsWith("P")) {
            throw this.dateError(value, "P2000Y12M", info);
        }
        this.yearMonth(value, mt, info);
        this.sec = BigDecimal.ZERO;
    }

    public long ymd() {
        return this.mon;
    }

    @Override
    public byte[] string(InputInfo info) {
        TokenBuilder tb = new TokenBuilder();
        if (this.mon < 0L) {
            tb.add(45);
        }
        this.date(tb);
        if (this.mon == 0L) {
            tb.add("0M");
        }
        return tb.finish();
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        if (item.type != this.type) {
            throw QueryError.diffError(item, this, info);
        }
        long m = this.mon - ((Dur)item).mon;
        return m < 0L ? -1 : (m > 0L ? 1 : 0);
    }
}

